% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/B00-marCoxph.R
\name{marCoxph}
\alias{marCoxph}
\title{Marginal Cox Model with Propensity Score Weighting}
\usage{
marCoxph(
  data,
  ps_formula,
  time_var,
  event_var,
  reference_level,
  estimand = "ATE",
  att_group = NULL,
  trim = NULL,
  delta = NULL,
  alpha = NULL,
  variance_method = "bootstrap",
  boot_level = "full",
  B = 100,
  parallel = FALSE,
  mc.cores = 2,
  seed = NULL,
  ps_control = list(),
  robust = TRUE
)
}
\arguments{
\item{data}{Data frame containing treatment, survival outcome, and covariates.}

\item{ps_formula}{Formula for propensity score model: \code{treatment ~ covariates}.}

\item{time_var}{Character string specifying the time-to-event variable name.}

\item{event_var}{Character string specifying the event indicator variable name.
Should be coded as 1=event, 0=censored.}

\item{reference_level}{Treatment level to use as reference in Cox model. MANDATORY.
Must be one of the treatment levels.}

\item{estimand}{Target estimand: "ATE" (average treatment effect), "ATT" (average
treatment effect on the treated), or "overlap" (overlap weighting). Default "ATE".}

\item{att_group}{Target group for ATT. Required if \code{estimand = "ATT"}.}

\item{trim}{Trimming method: "symmetric" or "asymmetric". Default NULL (no trimming).}

\item{delta}{Threshold for symmetric trimming (e.g., 0.1). Required if \code{trim = "symmetric"}.}

\item{alpha}{Percentile for asymmetric trimming (e.g., 0.05). Required if \code{trim = "asymmetric"}.}

\item{variance_method}{Variance estimation method: "bootstrap" (default) or "robust".
"bootstrap" resamples the entire analysis pipeline. "robust" uses the sandwich
variance estimator from \code{coxph()} without bootstrap.}

\item{boot_level}{Bootstrap sampling level: "full" (default) or "strata".
"full" resamples from entire dataset (standard for observational studies). "strata"
resamples within each treatment group preserving group sizes (useful when treatment assignment 
follows a stratified or fixed-ratio design). Only used if \code{variance_method = "bootstrap"}.}

\item{B}{Number of bootstrap iterations. Default 100. Used only if \code{variance_method = "bootstrap"}.}

\item{parallel}{Logical. Use parallel bootstrap computation? Default FALSE.}

\item{mc.cores}{Number of cores for parallel bootstrap. Default 2.}

\item{seed}{Random seed for bootstrap reproducibility. Default NULL.}

\item{ps_control}{Control parameters for propensity score model. Default \code{list()}.}

\item{robust}{Logical. Use robust (sandwich) variance in Cox model fitting?
Default TRUE. When TRUE, \code{coxph()} is called with \code{robust = TRUE}.}
}
\value{
Object of class "marCoxph" containing:
  \item{coxph_fitted}{Fitted \code{coxph} model object.}
  \item{logHR_est}{Named vector of estimated log hazard ratios. Names are formatted
    as "treatment_var:level" (e.g., "Z:B" for treatment Z, level B vs reference).}
  \item{logHR_se_robust}{Named vector of robust standard errors from \code{coxph}.}
  \item{logHR_se_bootstrap}{Named vector of bootstrap standard errors. NULL if
    \code{variance_method = "robust"}.}
  \item{n_coxph_fitted}{Named vector of sample sizes per treatment group used in
    Cox model fitting (after trimming).}
  \item{events_coxph_fitted}{Named vector of event counts per treatment group used
    in Cox model fitting (after trimming).}
  \item{variance_method}{Variance method used: "bootstrap-full", "bootstrap-strata",
    or "robust".}
  \item{estimand}{Target estimand used.}
  \item{att_group}{Target group for ATT (NULL if not applicable).}
  \item{trim_method}{Trimming method (NULL if no trimming).}
  \item{delta}{Symmetric trimming threshold (NULL if not applicable).}
  \item{alpha}{Asymmetric trimming threshold (NULL if not applicable).}
  \item{treatment_var}{Name of treatment variable.}
  \item{treatment_levels}{Sorted unique treatment values.}
  \item{reference_level}{Reference level used in Cox model.}
  \item{n_levels}{Number of treatment groups.}
  \item{n}{Number of complete cases used in analysis.}
  \item{ps_result}{Propensity score estimation results.}
  \item{weight_result}{Weight estimation results.}
  \item{boot_result}{Bootstrap results (NULL if \code{variance_method = "robust"}).
    Contains: boot_samples, boot_allocation, n_success_by_group, B.}
}
\description{
Main user interface for estimating marginal hazard ratios using propensity
score weighting. Supports binary and multiple treatment groups with various
weighting schemes (ATE, ATT, overlap) and optional trimming. Variance can be
estimated via bootstrap or robust sandwich estimator.
}
\details{
**Analysis Workflow:**
1. Extract treatment variable from \code{ps_formula}.
2. Estimate propensity scores using multinomial logistic regression (or logistic
   for binary treatment).
3. Calculate propensity score weights based on \code{estimand} and optional \code{trim}.
4. Fit marginal Cox model \code{Surv(time, event) ~ treatment} with weights.
5. Estimate variance via bootstrap (resampling full pipeline) or robust sandwich
   estimator.

**Variance Estimation:**
- \code{bootstrap}: Resamples data (full or stratified), re-estimates PS and weights,
  re-fits Cox model. Provides bootstrap SE for log hazard ratios.
- \code{robust}: Uses robust sandwich variance from \code{coxph()} directly. No
  bootstrap performed (faster but may be less accurate with extreme weights).

**Trimming:**
- Symmetric: Crump extension for multiple treatments (Yoshida et al., 2019).
- Asymmetric: Sturmer extension for multiple treatments (Yoshida et al., 2019).
- Not supported with overlap weights (already bounded [0,1]).
}
\examples{
\donttest{
# Example 1: Binary treatment with overlap weighting
data(simdata_bin)
result1 <- marCoxph(
  data = simdata_bin,
  ps_formula = Z ~ X1 + X2 + X3 + B1 + B2,
  time_var = "time",
  event_var = "event",
  reference_level = "A",
  estimand = "overlap"
)
summary(result1)

# Example 2: Multiple treatments with ATT and robust variance
data(simdata_multi)
result2 <- marCoxph(
  data = simdata_multi,
  ps_formula = Z ~ X1 + X2 + X3 + B1 + B2,
  time_var = "time",
  event_var = "event",
  reference_level = "C",
  estimand = "ATT",
  att_group = "C",
  variance_method = "robust"
)
summary(result2)
}

}
\references{
Li, F., & Li, F. (2019). Propensity score weighting for causal inference with
multiple treatments. \emph{The Annals of Applied Statistics}, 13(4), 2389-2415.

Yoshida, K., et al. (2019). Multinomial extension of propensity score trimming
methods: A simulation study. \emph{American Journal of Epidemiology}, 188(3),
609-616.
}
