% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DPC-PSSM.R
\name{DPC_PSSM}
\alias{DPC_PSSM}
\title{DPC-PSSM,AAC-PSSM and AADP-PSSM feature vectors}
\usage{
DPC_PSSM(pssm_name)
}
\arguments{
\item{pssm_name}{name of PSSM Matrix file}
}
\value{
feature vector of length 420
}
\description{
This feature is combination of amino asid composition and dipeptide composition feature
vectors. DPC feature stands for dipeptide composition, which multiplies the values in two consecutive
rows and two different columns, calculating this for each of the different columns and obtaining the
sum of these and for each. And for both columns, the product divides their sum by L-1, and because the
result depends on two different columns, length of this feature vector would be 400. AAC-PSSM is actually
mean of PSSM Matrix columns which its length is 20. eventually AADP-PSSM is combination of these vectors
and with length 420.
}
\examples{
ss<-DPC_PSSM(system.file("extdata", "C7GQS7.txt.pssm", package="PSSMCOOL"))
}
\references{
Liu, T., Zheng, X. and Wang, J. (2010) Prediction of protein structural class for
low-similarity sequences using support vector machine and PSI-BLAST profile, Biochimie, 92, 1330-1334.
}
