% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PRS_Dis_LDpred2.R
\name{PRS_Dis_LDpred2}
\alias{PRS_Dis_LDpred2}
\title{Construct disease PRS using LDpred2}
\usage{
PRS_Dis_LDpred2(DIS_GWAS, G_reference, pcausal, h2)
}
\arguments{
\item{DIS_GWAS}{a numeric matrix containing disease GWAS summary statistics, including SNP ID, position, \eqn{\beta}, SE(\eqn{\beta}), p-value, N, and MAF}

\item{G_reference}{a numeric matrix containing the individual-level genotype information from the reference panel (e.g., 1KG)}

\item{pcausal}{a numeric value indicating the hyper-parameter as the proportion of causal variants}

\item{h2}{a numeric value indicating the estimated heritability}
}
\value{
A numeric list, the first sublist contains estimated prognostic effect sizes, the second sublist contains estimated predictive effect sizes
}
\description{
Using snp_ldpred2_grid function from bigsnpr function
}
\details{
PRS-Dis-LDpred2 automatically sets predictive effect sizes equivalent to the prognostic effect sizes; and only need disease GWAS summary statistics and external reference genotype
}
\examples{
\donttest{
data(PRSPGx.example); attach(PRSPGx.example)
coef_est <- PRS_Dis_LDpred2(DIS_GWAS, G_reference, pcausal = 0.1, h2 = 0.4)
summary(coef_est$coef.G)
summary(coef_est$coef.TG)
}

}
\references{
Prive, F., Arbel, J. & Vilhjalmsson, B.J. LDpred2: better, faster, stronger. Bioinformatics 36, 5424-5431 (2020).

Zhai, S., Zhang, H., Mehrotra, D.V. & Shen, J. Paradigm Shift from Disease PRS to PGx PRS for Drug Response Prediction using PRS-PGx Methods (submitted).
}
\author{
Song Zhai
}
