% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linking_functions.R
\name{runEquateObserved}
\alias{runEquateObserved}
\title{Run Test Equating}
\usage{
runEquateObserved(
  data,
  scale_from = 2,
  scale_to = 1,
  type_to = "raw",
  rsss = NULL,
  eq_type = "equipercentile",
  smooth = "loglinear",
  degrees = list(3, 1),
  boot = TRUE,
  reps = 100,
  ...
)
}
\arguments{
\item{data}{a \code{\linkS4class{PROsetta_data}} object. See \code{\link{loadData}} for loading a dataset.}

\item{scale_from}{the scale ID of the input scale. References to \code{itemmap} in \code{data} argument.}

\item{scale_to}{the scale ID of the target scale to equate to. References to \code{itemmap} in \code{data} argument.}

\item{type_to}{the type of score to use in the target scale frequency table. Accepts \code{raw}, \code{tscore}, and \code{theta}. \code{tscore} and \code{theta} require argument \code{rsss} to be supplied. (default = \code{raw})}

\item{rsss}{the RSSS table to use to map each raw score level onto a t-score or a theta. See \code{\link{runRSSS}}.}

\item{eq_type}{the type of equating to be passed onto \code{\link[equate]{equate}} in \href{https://CRAN.R-project.org/package=equate}{'equate'} package.}

\item{smooth}{the type of smoothing method to be passed onto \code{\link[equate]{presmoothing}} in \href{https://CRAN.R-project.org/package=equate}{'equate'} package.}

\item{degrees}{the degrees of smoothing to be passed onto \code{\link[equate]{presmoothing}}.}

\item{boot}{performs bootstrapping if \code{TRUE}.}

\item{reps}{the number of replications to perform in bootsrapping.}

\item{...}{other arguments to pass onto \code{\link[equate]{equate}}.}
}
\value{
\code{\link{runEquateObserved}} returns an \code{\link{equate}} object containing the test equating result.

The printed summary statistics indicate the distributional properties of the two supplied scales and the equated scale.
\itemize{
  \item{\code{x}} corresponds to \code{scale_from}.
  \item{\code{y}} corresponds to \code{scale_to}.
  \item{\code{yx}} corresponds to \code{scale_from} after equating to \code{scale_to}.
}
See \code{\link[equate]{equate}} for details.

The concordance table is stored in \code{concordance} slot.
}
\description{
\code{\link{runEquateObserved}} is a function to perform equipercentile test equating between two scales. A concordance table is produced, mapping the observed raw scores from one scale to the scores from another scale.
}
\examples{
out_eq_raw <- runEquateObserved(data_asq,
  scale_to = 1, scale_from = 2,
  eq_type = "equipercentile", smooth = "loglinear"
)
out_eq_raw$concordance

\donttest{
out_link <- runLinking(data_asq, method = "FIXEDPAR")
out_rsss <- runRSSS(data_asq, out_link)
out_eq_tscore <- runEquateObserved(data_asq,
  scale_to = 1, scale_from = 2,
  type_to = "tscore", rsss = out_rsss,
  eq_type = "equipercentile", smooth = "loglinear"
)
out_eq_tscore$concordance
}
}
