/*******************************************************************************
 * Copyright (c) 2017, College of William & Mary
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the College of William & Mary nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COLLEGE OF WILLIAM & MARY BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * PRIMME: https://github.com/primme/primme
 * Contact: Andreas Stathopoulos, a n d r e a s _at_ c s . w m . e d u
 *******************************************************************************
 *   NOTE: THIS FILE IS AUTOMATICALLY GENERATED. PLEASE DON'T MODIFY
 ******************************************************************************/


#ifndef correction_H
#define correction_H
#if !defined(CHECK_TEMPLATE) && !defined(solve_correction_Sprimme)
#  define solve_correction_Sprimme CONCAT(solve_correction_,SCALAR_SUF)
#endif
#if !defined(CHECK_TEMPLATE) && !defined(solve_correction_Rprimme)
#  define solve_correction_Rprimme CONCAT(solve_correction_,REAL_SUF)
#endif
int solve_correction_dprimme(double *V, PRIMME_INT ldV, double *W,
      PRIMME_INT ldW, double *evecs, PRIMME_INT ldevecs, double *evecsHat,
      PRIMME_INT ldevecsHat, double *UDU, int *ipivot, double *lockedEvals,
      int numLocked, int numConvergedStored, double *ritzVals,
      double *prevRitzVals, int *numPrevRitzVals, int *flags, int basisSize,
      double *blockNorms, int *iev, int blockSize, int *touch, double machEps,
      double *rwork, size_t *rworkSize, int *iwork, int iworkSize,
      primme_params *primme);
int solve_correction_zprimme(PRIMME_COMPLEX_DOUBLE *V, PRIMME_INT ldV, PRIMME_COMPLEX_DOUBLE *W,
      PRIMME_INT ldW, PRIMME_COMPLEX_DOUBLE *evecs, PRIMME_INT ldevecs, PRIMME_COMPLEX_DOUBLE *evecsHat,
      PRIMME_INT ldevecsHat, PRIMME_COMPLEX_DOUBLE *UDU, int *ipivot, double *lockedEvals,
      int numLocked, int numConvergedStored, double *ritzVals,
      double *prevRitzVals, int *numPrevRitzVals, int *flags, int basisSize,
      double *blockNorms, int *iev, int blockSize, int *touch, double machEps,
      PRIMME_COMPLEX_DOUBLE *rwork, size_t *rworkSize, int *iwork, int iworkSize,
      primme_params *primme);
int solve_correction_sprimme(float *V, PRIMME_INT ldV, float *W,
      PRIMME_INT ldW, float *evecs, PRIMME_INT ldevecs, float *evecsHat,
      PRIMME_INT ldevecsHat, float *UDU, int *ipivot, float *lockedEvals,
      int numLocked, int numConvergedStored, float *ritzVals,
      float *prevRitzVals, int *numPrevRitzVals, int *flags, int basisSize,
      float *blockNorms, int *iev, int blockSize, int *touch, double machEps,
      float *rwork, size_t *rworkSize, int *iwork, int iworkSize,
      primme_params *primme);
int solve_correction_cprimme(PRIMME_COMPLEX_FLOAT *V, PRIMME_INT ldV, PRIMME_COMPLEX_FLOAT *W,
      PRIMME_INT ldW, PRIMME_COMPLEX_FLOAT *evecs, PRIMME_INT ldevecs, PRIMME_COMPLEX_FLOAT *evecsHat,
      PRIMME_INT ldevecsHat, PRIMME_COMPLEX_FLOAT *UDU, int *ipivot, float *lockedEvals,
      int numLocked, int numConvergedStored, float *ritzVals,
      float *prevRitzVals, int *numPrevRitzVals, int *flags, int basisSize,
      float *blockNorms, int *iev, int blockSize, int *touch, double machEps,
      PRIMME_COMPLEX_FLOAT *rwork, size_t *rworkSize, int *iwork, int iworkSize,
      primme_params *primme);
#endif
