% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shapPPlong.R
\name{ppshapr_prep}
\alias{ppshapr_prep}
\title{Calculate \code{PPKernelSHAP} for all train data set}
\usage{
ppshapr_prep(PPTreeregOBJ = NULL, final.rule = 5, method = "simple")
}
\arguments{
\item{PPTreeregOBJ}{PPTreereg class object - a model to be explained}

\item{final.rule}{final rule to assign numerical values in the final nodes.
1: mean value in the final nodes
2: median value in the final nodes
3: using optimal projection
4: using all independent variables
5: using several significant independent variables}

\item{method}{simple or empirical method to calculate \code{PPKernelSHAP}}
}
\value{
ppshapr_prep class object
}
\description{
All train data set to calculate \code{PPKernelSHAP}
}
\examples{
data(dataXY)
testX <- dataXY[1,-1]
Model <- PPTreereg(Y~., data = dataXY, DEPTH = 2)
shap_long <- ppshapr_prep(Model, final.rule =5, method="simple")

}
