% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Huberplot.R
\name{Huber.plot}
\alias{Huber.plot}
\title{Draw Huber plot for 2D data with various PP index}
\usage{
Huber.plot(origdata2D,origclass,PPmethod,weight,r,lambda,
           opt.proj,UserDefFtn,...)
}
\arguments{
\item{origdata2D}{2D data for Huber plot}

\item{origclass}{class information}

\item{PPmethod}{method for projection pursuit; "LDA", "PDA", "Lr", "GINI", and "ENTROPY"}

\item{weight}{weight flag in LDA, PDA and Lr index}

\item{r}{r in Lr index}

\item{lambda}{lambda in PDA index}

\item{opt.proj}{flag to show the best projection in the plot}

\item{UserDefFtn}{User defined index function}

\item{...}{arguments to be passed to methods}
}
\description{
Draw Huber plot for 2D data with various PP index
}
\examples{
data(iris)
Huber.plot(iris[,1:2],iris[,5],PPmethod="LDA")
}
\references{
Lee, EK., Cook, D., Klinke, S., and Lumley, T.(2005)
Projection Pursuit for exploratory supervised classification,
Journal of Computational and Graphical statistics, 14(4):831-846.
}
\keyword{projection}
\keyword{pursuit}

