#' Astralian crabs 
#' 
#' Measurements on rock crabs of the genus Leptograpsus. The data set contains 200 observations
#'  from two species of crab (blue and orange), there are 50 specimens of each sex of each species,
#'   collected on site at Fremantle, Western Australia. 
#' \itemize{
#'   \item{Type}{ is the class variable and has 4 classes with the combinations of specie and sex (BlueMale, BlueFemale, OrangeMale and OrangeFemale)}. 
#'   \item{FL}{the size of the frontal lobe length, in mm}
#'   \item{RW}{rear width, in mm}
#'   \item{CL}{length of midline of the carapace, in mm}
#'   \item{CW}{maximum width of carapace, in mm}
#'   \item{BD}{depth of the body; for females, measured after displacement of the abdomen, in mm}
#' }
#' @docType data
#' @keywords datasets
#' @name crab
#' @usage data(crab)
#' @format A data frame with 200 rows and 6 variables
#' @source Campbell, N. A. & Mahon, R. J. (1974), A Multivariate Study of Variation in Two Species of Rock Crab of genus Leptograpsus, Australian Journal of Zoology 22(3), 417 - 425.
NULL
