% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{PPQ.ctplot}
\alias{PPQ.ctplot}
\title{Heatmap/Contour Plot for Assessing Power of the CQA PPQ Plan Using General Multiplier.}
\usage{
PPQ.ctplot(attr.name, attr.unit, Llim, Ulim, mu, sigma, n, n.batch, k, test.point)
}
\arguments{
\item{attr.name}{(optional) user-defined attribute name for PPQ assessment}

\item{attr.unit}{(optional) user-defined attribute unit}

\item{Llim}{lower specification limit}

\item{Ulim}{upper specification limit}

\item{mu}{hypothetical mean of the attribute}

\item{sigma}{hypothetical standard deviation of the attribute}

\item{n}{sample size (number of locations) per batch}

\item{n.batch}{number of batches for passing PPQ during validation}

\item{k}{general mulipler for constructing the specific interval}

\item{test.point}{(optional) actual process data points for testing whether the processes pass PPQ}
}
\value{
Heatmap (or Countour Plot) for PPQ Assessment.
}
\description{
The function for plotting the heatmap to evaluate the PPQ plan based on the specification test, given lower and upper specification limits.
}
\examples{
mu <- seq(1.6,3.4,0.05)
sigma <- seq(0.05,0.8,0.01)
PPQ.ctplot(attr.name = "Total Protein", attr.unit = "mg/mL", Llim=1.5, Ulim=3.5,
mu = mu, sigma = sigma, k=2.373)

## Example verifying simulation resutls in the textbook page 249
mu <- seq(95, 105, 0.1)
sigma <- seq(0.2, 5, 0.1)
PPQ.ctplot(attr.name = "Composite Assay", attr.unit = "\%LC", Llim=95, Ulim=105,
mu = mu, sigma = sigma, k=2.373)
mu <- seq(90, 110, 0.5)
PPQ.ctplot(attr.name = "Composite Assay", attr.unit = "\%LC", Llim=90, Ulim=110,
mu = mu, sigma = sigma, k=2.373)

mu <- seq(95,105,0.1)
sigma <- seq(0.1,2.5,0.1)
PPQ.ctplot(attr.name = "Sterile Concentration Assay", attr.unit = "\%", Llim=95, Ulim=105,
mu = mu, sigma = sigma, k=2.373)
test <- data.frame(mean=c(97,98.3,102.5), sd=c(0.55, 1.5, 1.2))
PPQ.ctplot(attr.name = "Sterile Concentration Assay", attr.unit = "\%", Llim=95, Ulim=105,
mu = mu, sigma = sigma, k=2.373, test.point=test)

}
\references{
Burdick, R. K., LeBlond, D. J., Pfahler, L. B., Quiroz, J., Sidor, L., Vukovinsky, K., & Zhang, L. (2017).
Statistical Applications for Chemistry, Manufacturing and Controls (CMC) in the Pharmaceutical Industry.
\emph{Springer}.
}
\seealso{
\code{PPQ.pp} and \code{PPQ.occurve}.
}
\author{
Yalin Zhu
}
