% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{arfima.coefs}
\alias{arfima.coefs}
\title{Coefficients of an ARFIMA(p,d,q) model}
\usage{
arfima.coefs(ar = NULL, ma = NULL, d = 0, trunc = 1)
}
\arguments{
\item{ar}{the coefficients of the autoregressive polinomial. Default is NULL}

\item{ma}{the coefficients of the moving average polinomial. Default is null}

\item{d}{the long memory parameter. Default is 0.}

\item{trunc}{the truncation point. Default is 1.}
}
\value{
The coefficients values up to order \sQuote{trunc}.
}
\description{
This function calculates the coefficients \eqn{c_k, k \geq 0} corresponding to
\eqn{\theta(z)\phi^{-1}(z)(1-z)^{-d} = \sum_{k = 0}^{\infty}c_k z^k},
up to a truncation point
}
\examples{
cks <- arfima.coefs(d = 0.3, trunc = 5)
cks

cks <- arfima.coefs(d = 0.1, trunc = 5, ar = 0.5, ma = 0.6)
cks

}
