% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likPOUMM.R
\name{likPOUMMGivenTreeVTipsC}
\alias{likPOUMMGivenTreeVTipsC}
\title{Fast POUMM likelihood calculation based on the breadth-first pruning algorithm
and Armadillo-library vector operations.}
\usage{
likPOUMMGivenTreeVTipsC(integrator, alpha, theta, sigma, sigmae, g0 = NA,
  g0Prior = NULL, log = TRUE)
}
\arguments{
\item{integrator}{An object of the Integrator C++ class (see example).
trait values at the tip-nodes.}

\item{alpha}{the strength of the selection}

\item{theta}{long term mean value of the OU process}

\item{sigma}{the unit-time standard deviation of the random component in the
OU process.}

\item{sigmae}{the standard deviation of the environmental deviation added to
the genetic contribution at each tip, by default 0, meaning no
environmental deviation.}

\item{g0}{Numeric, NA or NaN, either a fixed genotypic value at the root of 
tree or NA or NaN. A NA "Not Available" will cause to analytically
calculate the value of g0 that would maximize the conditional likelihood of
the data given g0. A NaN "Not a Number" will cause integration over g0
taking values in (-Inf,+Inf) assuming that g0 is normally distributed with
mean g0Prior$mean and variance g0Prior$var (see parameter g0Prior).}

\item{g0Prior}{Either NULL or a list with named numeric or character members
"mean" and "var". Specifies a prior normal distribution for the parameter g0.
If characters, the members mean and var are evaluated as R-expressions.}

\item{log}{Logical indicating whether log-likelihood should be returned
instead of likelihood, default is TRUE.}
}
\value{
A numeric with attributes "g0" and "g0LogPrior".
}
\description{
Fast POUMM likelihood calculation based on the breadth-first pruning algorithm
and Armadillo-library vector operations.
}
\details{
This function is the C++ equivalent of dVTipsGivenTreePOUMM (aliased also as
likPOUMMGivenTreeVTips). C++ implementation using contiguous vector operations and
 vectors a, b and c
}
\examples{
\dontrun{
N <- 100
tr <- ape::rtree(N)
z <- POUMM::rVNodesGivenTreePOUMM(tr, 0, 2, 3, 1, 1)[1:N]
pruneInfo <- POUMM::pruneTree(tr, z)
microbenchmark::microbenchmark(
  likArma <- POUMM::likPOUMMGivenTreeVTipsC(pruneInfo$integrator, 2, 3, 1, 1),
  likR <- POUMM::likPOUMMGivenTreeVTips(z, tr, 2, 3, 1, 1, pruneInfo = pruneInfo))

# should be the same values
likArma
likR
}

}

