% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.POST.R
\name{plot}
\alias{plot}
\alias{plot.POST}
\title{Plot Phylogenies with Significant OTU}
\usage{
\method{plot}{POST}(x, ..., siglevel = 0.05, method = "none", alpha = 0.05, subTree = TRUE)
}
\arguments{
\item{x}{A POST object. The value object returned by post(). Note that
a tree of class "phylo" must have been provided to the original
analysis.}

\item{...}{Additional arguments to be passed to plot.phylo.}

\item{siglevel}{A numeric object. The significance level; OTU's with 
(adjusted or raw) p-values below this level will be highlighted.
Default is 0.05.}

\item{method}{A character object. Must be one of \{"holm", "hochberg", 
"hommel", "bonferroni", "BH", "BY", "fdr", "TSBH", "none"\}, where
'none' indicates the raw POST p-values. "TSBH" is the
two-stage Benjamini & Hochberg procedure. See ?stats::p.adjust for 
descriptions of all other possible values.}

\item{alpha}{A numeric object. A nominal type I error rate, or a vector of 
error rates, used for estimating the number of true null hypotheses in 
the two-stage Benjamini & Hochberg procedure ("TSBH"). Default is 0.05.
Ignored if method is not TSBH.}

\item{subTree}{A logical object. If TRUE, only the OTU used in the
analysis are included in the plot.}
}
\value{
No return value, called to produce graphical elements.
}
\description{
Plot phylogenetic tree on the current graphical device as defined by
 package ape with tip labels highlighted to show the significant OTU.
}
\examples{

data("POSTmData")

y <- as.integer(x = metadata[,"GC"] == "BV")
X <- metadata[,"mRace"]

result <- post(y = y, 
               X = X, 
               OTU = otu[,1:20], 
               tree = otutree,
               cValues = seq(0,0.05,by=0.01))

plot(x = result)

}
