% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pnadc_design.R
\name{pnadc_design}
\alias{pnadc_design}
\title{Create pnadc survey object utilizing its sampling design for analysis with survey package}
\usage{
pnadc_design(data_pnadc)
}
\arguments{
\item{data_pnadc}{A tibble of PNADc data read with \code{read_pnadc} function.}
}
\value{
An object of class \code{survey.design} with the data from PNADc survey and its sample design.
}
\description{
Create pnadc survey object utilizing its sampling design for analysis with survey package
}
\examples{

#Using data read from disk
input_path <- pnadc_example(path="input_example.txt")
data_path <- pnadc_example(path="exampledata.txt")
pnadc.df <- read_pnadc(microdata=data_path, input_txt=input_path, vars="VD4002")
dictionary.path <- pnadc_example(path="dictionaryexample.xls")
pnadc.df <- pnadc_labeller(data_pnadc=pnadc.df, dictionary.file=dictionary.path)
\dontrun{
pnadc.svy <- pnadc_design(data_pnadc=pnadc.df)
#Calculating unemployment rate
survey::svymean(~VD4002, pnadc.svy, na.rm=TRUE)}

#Downloading data
\dontrun{
pnadc.df2 <- get_pnadc(year=2017, quarter=2, vars="VD4002", labels=F, design=F)
pnadc.df2 <- pnadc_labeller(data_pnadc=pnadc.df2, dictionary.file=dictionary.path)
pnadc.svy2 <- pnadc_design(data_pnadc=pnadc.df2)
#Calculating unemployment rate
survey::svymean(~VD4002, pnadc.svy2, na.rm=TRUE)}
}
