% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_pnadc.R
\name{read_pnadc}
\alias{read_pnadc}
\title{Read PNADc microdata}
\usage{
read_pnadc(microdata, input_txt, vars = NULL)
}
\arguments{
\item{microdata}{A text file containing microdata from PNADc survey. The file must be downloaded from \url{ftp://ftp.ibge.gov.br/Trabalho_e_Rendimento/Pesquisa_Nacional_por_Amostra_de_Domicilios_continua/Trimestral/Microdados/}}

\item{input_txt}{A text file available along with the microdata containing the input script for SAS. They are available at \url{ftp://ftp.ibge.gov.br/Trabalho_e_Rendimento/Pesquisa_Nacional_por_Amostra_de_Domicilios_continua/Trimestral/Microdados/Documentacao/Dicionario_e_input.zip}}

\item{vars}{Character vector of the name of the variables you want to keep for analysys. \code{default} is to keep all variables}
}
\value{
A tibble with the survey design variables and selected variables.
}
\description{
Read PNADc microdata
}
\examples{
input_path <- pnadc_example("input_example.txt")
data_path <- pnadc_example("exampledata.txt")
pnadc.df <- read_pnadc(data_path,input_path,vars="VD4002")
}
