% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gamesHowellTest.R
\name{gamesHowellTest}
\alias{gamesHowellTest}
\alias{gamesHowellTest.default}
\alias{gamesHowellTest.formula}
\alias{gamesHowellTest.aov}
\title{Games-Howell Test}
\usage{
gamesHowellTest(x, ...)

\method{gamesHowellTest}{default}(x, g, ...)

\method{gamesHowellTest}{formula}(formula, data, subset, na.action, ...)

\method{gamesHowellTest}{aov}(x, ...)
}
\arguments{
\item{x}{a numeric vector of data values, a list of numeric data
vectors or a fitted model object, usually an \link[stats]{aov} fit.}

\item{\dots}{further arguments to be passed to or from methods.}

\item{g}{a vector or factor object giving the group for the
corresponding elements of \code{"x"}.
Ignored with a warning if \code{"x"} is a list.}

\item{formula}{a formula of the form \code{response ~ group} where
\code{response} gives the data values and \code{group} a vector or
factor of the corresponding groups.}

\item{data}{an optional matrix or data frame (or similar: see
\code{\link{model.frame}}) containing the variables in the
formula \code{formula}.  By default the variables are taken from
\code{environment(formula)}.}

\item{subset}{an optional vector specifying a 
subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when
the data contain \code{NA}s.  Defaults to \code{getOption("na.action")}.}
}
\value{
A list with class \code{"PMCMR"} containing the following components:
\describe{
 \item{method}{a character string indicating what type of test was performed.}
 \item{data.name}{a character string giving the name(s) of the data.}
 \item{statistic}{lower-triangle matrix of the estimated
quantiles of the pairwise test statistics.}
 \item{p.value}{lower-triangle matrix of the p-values for the pairwise tests.}
 \item{alternative}{a character string describing the alternative hypothesis.}
\item{p.adjust.method}{a character string describing the method for p-value
adjustment.}
\item{model}{a data frame of the input data.}
\item{dist}{a string that denotes the test distribution.}
}
}
\description{
Performs Games-Howell all-pairs comparison test for normally distributed
data with unequal group variances.
}
\details{
For all-pairs comparisons in an one-factorial layout
with normally distributed residuals but unequal between-groups variances
the Games-Howell Test can be performed.  Let \eqn{X_{ij}} denote a continuous random variable
with the \eqn{j}-the realization (\eqn{1 \le j \le n_i})
in the \eqn{i}-th group (\eqn{1 \le i \le k}). Furthermore, the total
sample size is \eqn{N = \sum_{i=1}^k n_i}. A total of \eqn{m = k(k-1)/2}
hypotheses can be tested: The null hypothesis is
H\eqn{_{ij}: \mu_i = \mu_j ~~ (i \ne j)} is tested against the alternative
A\eqn{_{ij}: \mu_i \ne \mu_j} (two-tailed). Games-Howell Test all-pairs
test statistics are given by

\deqn{
 t_{ij} \frac{\bar{X}_i - \bar{X_j}}
 {\left( s^2_j / n_j + s^2_i / n_i \right)^{1/2}}, ~~
 (i \ne j)
}{%
 SEE PDF
}

with \eqn{s^2_i} the variance of the \eqn{i}-th group.
The null hypothesis is rejected (two-tailed) if

\deqn{
 \mathrm{Pr} \left\{ |t_{ij}| \sqrt{2} \ge q_{m v_{ij} \alpha} | \mathrm{H} \right\}_{ij} =
 \alpha,
}{%
 SEE PDF
}

with Welch's approximate solution for calculating the degree of freedom.

\deqn{
 v_{ij} = \frac{\left( s^2_i / n_i + s^2_j / n_j \right)^2}
 {s^4_i / n^2_i \left(n_i - 1\right) + s^4_j / n^2_j \left(n_j - 1\right)}.
}{%
 SEE PDF
}

The \eqn{p}-values are computed from the
\code{\link[stats]{Tukey}} distribution.
}
\examples{
fit <- aov(weight ~ feed, chickwts)
shapiro.test(residuals(fit))
bartlett.test(weight ~ feed, chickwts) # var1 = varN
anova(fit)

## also works with fitted objects of class aov
res <- gamesHowellTest(fit)
summary(res)
summaryGroup(res)

}
\seealso{
\code{\link{Tukey}}
}
\concept{parametric}
\keyword{htest}
