% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frdManyOneNemenyiTest.R
\name{frdManyOneNemenyiTest}
\alias{frdManyOneNemenyiTest}
\alias{frdManyOneNemenyiTest.default}
\title{Nemenyi's Many-to-One Test
for Unreplicated Blocked Data}
\usage{
frdManyOneNemenyiTest(y, ...)

\method{frdManyOneNemenyiTest}{default}(
  y,
  groups,
  blocks,
  alternative = c("two.sided", "greater", "less"),
  ...
)
}
\arguments{
\item{y}{a numeric vector of data values, or a list of numeric data
vectors.}

\item{groups}{a vector or factor object giving the group for the
corresponding elements of \code{"x"}. Ignored with a warning if \code{"x"} is a list.}

\item{blocks}{a vector or factor object giving the block for the
corresponding elements of \code{"x"}.
Ignored with a warning if \code{"x"} is a list.}

\item{alternative}{the alternative hypothesis. Defaults to \code{two.sided}.}

\item{\ldots}{further arguments to be passed to or from methods.}
}
\value{
A list with class \code{"PMCMR"} containing the following components:
\describe{
 \item{method}{a character string indicating what type of test was performed.}
 \item{data.name}{a character string giving the name(s) of the data.}
 \item{statistic}{lower-triangle matrix of the estimated
quantiles of the pairwise test statistics.}
 \item{p.value}{lower-triangle matrix of the p-values for the pairwise tests.}
 \item{alternative}{a character string describing the alternative hypothesis.}
\item{p.adjust.method}{a character string describing the method for p-value
adjustment.}
\item{model}{a data frame of the input data.}
\item{dist}{a string that denotes the test distribution.}
}
}
\description{
Performs Nemenyi's non-parametric many-to-one comparison test
for Friedman-type ranked data.
}
\details{
For many-to-one comparisons (pairwise comparisons with one control)
in a two factorial unreplicated complete block design
with non-normally distributed residuals, Nemenyi's test can be
performed on Friedman-type ranked data.

Let there be \eqn{k} groups including the control,
then the number of treatment levels is \eqn{m = k - 1}.
A total of \eqn{m} pairwise comparisons can be performed between
the \eqn{i}-th treatment level and the control.
H\eqn{_i: \theta_0 = \theta_i} is tested in the two-tailed case against
A\eqn{_i: \theta_0 \ne \theta_i, ~~ (1 \le i \le m)}.

The \eqn{p}-values are computed from the multivariate normal distribution.
As \code{\link[mvtnorm]{pmvnorm}} applies a numerical method, the estimated
\eqn{p}-values are seet depended.
}
\examples{
 ## Sachs, 1997, p. 675
 ## Six persons (block) received six different diuretics
 ## (A to F, treatment).
 ## The responses are the Na-concentration (mval)
 ## in the urine measured 2 hours after each treatment.
 ## Assume A is the control.

 y <- matrix(c(
 3.88, 5.64, 5.76, 4.25, 5.91, 4.33, 30.58, 30.14, 16.92,
 23.19, 26.74, 10.91, 25.24, 33.52, 25.45, 18.85, 20.45, 
 26.67, 4.44, 7.94, 4.04, 4.4, 4.23, 4.36, 29.41, 30.72,
 32.92, 28.23, 23.35, 12, 38.87, 33.12, 39.15, 28.06, 38.23,
 26.65),nrow=6, ncol=6, 
 dimnames=list(1:6, LETTERS[1:6]))

 ## Global Friedman test
 friedmanTest(y)

 ## Demsar's many-one test
 frdManyOneDemsarTest(y=y, p.adjust = "bonferroni")

 ## Exact many-one test
 frdManyOneExactTest(y=y, p.adjust = "bonferroni")

 ## Nemenyi's many-one test
 frdManyOneNemenyiTest(y=y)
 
}
\references{
Hollander, M., Wolfe, D. A., Chicken, E. (2014),
\emph{Nonparametric Statistical Methods}. 3rd ed. New York: Wiley. 2014.

Miller Jr., R. G. (1996), \emph{Simultaneous Statistical Inference}.
 New York: McGraw-Hill.

Nemenyi, P. (1963), \emph{Distribution-free Multiple Comparisons}.
 Ph.D. thesis, Princeton University.

Siegel, S., Castellan Jr., N. J. (1988), \emph{Nonparametric
 Statistics for the Behavioral Sciences}. 2nd ed.
 New York: McGraw-Hill.

Zarr, J. H. (1999), \emph{Biostatistical Analysis}. 4th ed.
Upper Saddle River: Prentice-Hall.
}
\seealso{
\code{\link{friedmanTest}}, \code{\link[stats]{friedman.test}},
\code{\link{frdManyOneExactTest}}, \code{\link{frdManyOneDemsarTest}}
\code{\link[mvtnorm]{pmvnorm}}, \code{\link{set.seed}}
}
\concept{FriedmanTest}
\concept{ManyToOne}
\concept{Rank}
\keyword{htest}
\keyword{nonparametric}
