% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/durbinTest.R
\name{durbinTest}
\alias{durbinTest}
\alias{durbinTest.default}
\title{Durbin Test}
\usage{
durbinTest(y, ...)

\method{durbinTest}{default}(y, groups, blocks, ...)
}
\arguments{
\item{y}{a numeric vector of data values, or a list of numeric data
vectors.}

\item{groups}{a vector or factor object giving the group for the
corresponding elements of \code{"x"}. Ignored with a warning if \code{"x"} is a list.}

\item{blocks}{a vector or factor object giving the block for the
corresponding elements of \code{"x"}.
Ignored with a warning if \code{"x"} is a list.}

\item{\ldots}{further arguments to be passed to or from methods.}
}
\value{
A list with class \code{"htest"} containing the following components:
\describe{
 \item{method}{a character string indicating what type of test was performed.}
 \item{data.name}{a character string giving the name(s) of the data.}
 \item{statistic}{the estimated quantile of the test statistic.}
 \item{p.value}{the p-value for the test.}
 \item{parameter}{the parameters of the test statistic, if any.}
 \item{alternative}{a character string describing the alternative hypothesis.}
\item{estimates}{the estimates, if any.}
\item{null.value}{the estimate under the null hypothesis, if any.}
}
}
\description{
Performs Durbin's tests whether k groups
(or treatments) in a two-way balanced incomplete block design (BIBD)
have identical effects.
}
\details{
For testing a two factorial layout of a balanced incomplete
block design whether the \eqn{k} groups have identical effects,
the Durbin test can be performed. The null hypothesis,
H\eqn{_0: \theta_i = \theta_j ~ (1 \le i < j \le k)},
is tested against the alternative that at least
one \eqn{\theta_i \ne \theta_j}.

The p-values are computed from the chi-square distribution.
}
\note{
The function does not test, whether it is a true BIBD.
This function does not test for ties.
}
\examples{
## Example for an incomplete block design:
## Data from Conover (1999, p. 391).
y <- matrix(c(
2,NA,NA,NA,3, NA,  3,  3,  3, NA, NA, NA,  3, NA, NA,
  1,  2, NA, NA, NA,  1,  1, NA,  1,  1,
NA, NA, NA, NA,  2, NA,  2,  1, NA, NA, NA, NA,
 3, NA,  2,  1, NA, NA, NA, NA,  3, NA,  2,  2
), ncol=7, nrow=7, byrow=FALSE,
dimnames=list(1:7, LETTERS[1:7]))
durbinTest(y)
}
\references{
W. J. Conover (1999), \emph{Practical nonparametric Statistics},
3rd. Edition, Wiley.

N. A. Heckert and J. J. Filliben (2003). NIST Handbook 148:
Dataplot Reference Manual, Volume 2:
Let Subcommands and Library Functions.
National Institute of Standards and Technology Handbook Series, June 2003.
}
