% Generated by roxygen2 (4.0.1): do not edit by hand
\name{PLS.GLM.biplot_no_labels}
\alias{PLS.GLM.biplot_no_labels}
\title{The Partial Least Squares (PLS) biplot for Generalized Linear Model (GLM),  with the labels of the samples, coefficient points and tick markers excluded}
\usage{
PLS.GLM.biplot_no_labels(X, y, algorithm = NULL, ax.tickvec.X = NULL,
  ax.tickvec.y = NULL, ax.tickvec.b = NULL, ...)
}
\arguments{
\item{X}{A (NxP) predictor matrix}

\item{y}{A (Nx1) response vector}

\item{algorithm}{The PLS.GLM algorithm}

\item{ax.tickvec.X}{tick marker length for each X-variable axis in the biplot}

\item{ax.tickvec.y}{tick marker length for the y-variable axis in the biplot}

\item{ax.tickvec.b}{(purple) tick marker length for the y-variable axis in the biplot}

\item{...}{Other arguments. Currently ignored}
}
\value{
The PLS biplot of a GLM of D=[X y] with some parameters
}
\description{
Takes in a set of predictor variables and a set of response variables and produces a PLS biplot for the (univariate) GLMs, with the labels of the samples, coefficient points and tick markers excluded.
}
\examples{
if(require(robustbase))
possum.mat
y = as.matrix(possum.mat[,1], ncol=1)
dimnames(y) = list(paste("S", 1:nrow(possum.mat), seq=""), "Diversity")
X = as.matrix(possum.mat[,2:14], ncol=13)
dimnames(X) = list(paste("S", 1:nrow(possum.mat), seq=""), colnames(possum.mat[,2:14]))
PLS.GLM.biplot_no_labels(X, y, algorithm=PLS.GLM, ax.tickvec.X=rep(5,ncol(X)),
ax.tickvec.y=10, ax.tickvec.b=7)

#Pima.tr data
if(require(MASS))
data(Pima.tr, package="MASS")
X = as.matrix(cbind(Pima.tr[,1:7]))
dimnames(X) = list(1:nrow(X), colnames(X))
y = as.matrix(as.numeric(Pima.tr$type)-1, ncol=1)
#0=No and 1=Yes
dimnames(y) = list(1:nrow(y), paste("type"))
PLS.GLM.biplot_no_labels(X, y, algorithm=PLS.binomial.GLM,
ax.tickvec.X=c(3,3,8,7,8,5,2), ax.tickvec.y=3, ax.tickvec.b=3)
}
\author{
Opeoluwa F. Oyedele and Sugnet Gardner-Lubbe
}

