% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLNmixture.R
\name{PLNmixture_param}
\alias{PLNmixture_param}
\title{Control of a PLNmixture fit}
\usage{
PLNmixture_param(
  backend = "nlopt",
  trace = 1,
  covariance = "spherical",
  init_cl = "kmeans",
  smoothing = "both",
  config_optim = list(),
  config_post = list(),
  inception = NULL
)
}
\arguments{
\item{backend}{optimization back used, either "nlopt" or "torch". Default is "nlopt"}

\item{trace}{a integer for verbosity.}

\item{covariance}{character setting the model for the covariance matrices of the mixture components. Either "full", "diagonal" or "spherical". Default is "spherical".}

\item{init_cl}{The initial clustering to apply. Either, 'kmeans', CAH' or a user defined clustering given as a list of  clusterings, the size of which is equal to the number of clusters considered. Default is 'kmeans'.}

\item{smoothing}{The smoothing to apply. Either, 'none', forward', 'backward' or 'both'. Default is 'both'.}

\item{config_optim}{a list for controlling the optimizer (either "nlopt" or "torch" backend). See details}

\item{config_post}{a list for controlling the post-treatments (optional bootstrap, jackknife, R2, etc.).}

\item{inception}{Set up the parameters initialization: by default, the model is initialized with a multivariate linear model applied on
log-transformed data, and with the same formula as the one provided by the user. However, the user can provide a PLNfit (typically obtained from a previous fit),
which sometimes speeds up the inference.}
}
\value{
list of parameters configuring the fit.
}
\description{
Helper to define list of parameters to control the PLNmixture fit. All arguments have defaults.
}
\details{
See \code{\link[=PLN_param]{PLN_param()}} for a full description of the generic optimization parameters. PLNmixture_param() also has additional parameters controlling the optimization due the inner-outer loop structure of the optimizer:
\itemize{
\item "ftol_out" outer solver stops when an optimization step changes the objective function by less than xtol multiplied by the absolute value of the parameter. Default is 1e-6
\item "maxit_out" outer solver stops when the number of iteration exceeds maxit_out. Default is 50
\item "it_smoothing" number of the iterations of the smoothing procedure. Default is 1.
}
}
\seealso{
\code{\link[=PLN_param]{PLN_param()}}
}
