% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pl_select_standard.R
\name{pl_select_standard}
\alias{pl_select_standard}
\title{Select the Standard Redistricting Columns}
\usage{
pl_select_standard(pl, clean_names = TRUE)
}
\arguments{
\item{pl}{A list of PL tables, as read in by \code{\link[=pl_read]{pl_read()}}}

\item{clean_names}{whether to clean names}
}
\value{
A \link{tibble} with the selected and optionally renamed columns
}
\description{
Selects the standard set of basic population groups and VAP groups. Optionally
renames them from the PXXXYYYY naming convention (where XXX is the table and
YYYY is the variable) to more human readable names. pop_* is the total population,
from tables 1 and 2, while vap_* is the 18+ population (voting age population).
}
\details{
If \verb{clean names=TRUE}, then the variables extracted are as follows:
\itemize{
\item \verb{\\*_hisp}: Hispanic or Latino (of any race)
\item \verb{\\*_white}: White alone, not Hispanic or Latino
\item \verb{\\*_black}: Black or African American alone, not Hispanic or Latino
\item \verb{\\*_aian}: American Indian and Alaska Native alone, not Hispanic or Latino
\item \verb{\\*_asian}: Asian alone, not Hispanic or Latino
\item \verb{\\*_nhpi}: Native Hawaiian and Other Pacific Islander alone, not Hispanic or Latino
\item \verb{\\*_other}: Some Other Race alone, not Hispanic or Latino
\item \verb{\\*_two}: Population of two or more races, not Hispanic or Latino
}

where \* is \code{pop} or \code{vap}.
}
\examples{
\donttest{
pl_ex_path <- system.file('extdata/ri2018_2020Style.pl', package = 'PL94171')
pl <- pl_read(pl_ex_path)
pl <- pl_select_standard(pl)
}
}
\concept{basic}
