% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pl_crosswalk.R
\name{pl_retally}
\alias{pl_retally}
\title{Approximately re-tally Census data under new block boundaries}
\usage{
pl_retally(d_from, crosswalk)
}
\arguments{
\item{d_from}{The data frame to process. All numeric columns will be re-tallied.
Integer columns will be re-tallied with rounding.
Character columns will be preserved if constant across new block geometries.}

\item{crosswalk}{The crosswalk data frame, from \code{\link[=pl_crosswalk]{pl_crosswalk()}}}
}
\value{
A new data frame, like \code{d_from}, except with the geometry column
dropped, if one exists. New geometry should be loaded, perhaps with
\code{\link[tigris:blocks]{tigris::blocks()}}.
}
\description{
Applies a block crosswalk to a table of block data using areal interpolation.
That is, the fraction of land area in the overlapping region between old and
new blocks is used to divide the population of the old blocks into the new.
}
\details{
All numeric columns will be re-tallied. Integer columns will be re-tallied
with rounding. Character columns will be preserved if constant across new
block geometries.

Blocks from other states will be ignored.
}
\examples{
\donttest{
crosswalk = pl_crosswalk("RI", 2010, 2020)
RI_2010 = pl_tidy_shp("RI", pl_url("RI", 2010), 2010)
pl_retally(RI_2010, crosswalk)
}

}
\concept{advanced}
