% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OneComp_Volume_Clearance.R
\name{OneComp_Volume_Clearance}
\alias{OneComp_Volume_Clearance}
\title{Convert pharmacokinetic parameters for one compartment model}
\usage{
OneComp_Volume_Clearance(V1,Cl1,V1.sd=NA,Cl1.sd=NA,covar=c(V1Cl1=NA))
}
\arguments{
\item{V1}{The volume of distribution of compartment 1}

\item{Cl1}{Clearance from compartment 1}

\item{V1.sd}{standard error of V1}

\item{Cl1.sd}{standard error of Cl1}

\item{covar}{covariances among parameters}

\item{...}{arguments to be passed to methods}
}
\description{
Calculate pharmacokinetic parameters with volume of distribution (V1) and
clearance (Cl1)
}
\examples{
OneComp_Volume_Clearance(V1=8,Cl1=4,V1.sd=0.01,Cl1.sd=0.01)
}
\references{
\url{www.nonmemcourse.com/convert.xls}

Gabrielsson and Weiner(2006) Pharmacokinetic and
            Pharmacodynamic Data Analysis: Concepts and Applications,
            Swedish Academy of Pharmaceutical Sciences.
}
