% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk.calc.all.R
\name{pk.nca}
\alias{pk.nca}
\title{Compute NCA parameters for each interval for each subject.}
\usage{
pk.nca(data, verbose = FALSE)
}
\arguments{
\item{data}{A PKNCAdata object}

\item{verbose}{Indicate, by \code{message()}, the current state of
calculation.}
}
\value{
A \code{PKNCAresults} object.
}
\description{
The \code{pk.nca} function computes the NCA parameters from a
\code{PKNCAdata} object.  All options for the calculation and input data are
set in prior functions (\code{PKNCAconc}, \code{PKNCAdose}, and
\code{PKNCAdata}).  Options for calculations are set either in
\code{PKNCAdata} or with the current default options in \code{PKNCA.options}.
}
\details{
When performing calculations, all time results are relative to the start of
the interval.  For example, if an interval starts at 168 hours, ends at 192
hours, and and the maximum concentration is at 169 hours,
\code{tmax=169-168=1}.
}
\seealso{
\code{\link{PKNCAdata}}, \code{\link{PKNCA.options}},
 \code{\link{summary.PKNCAresults}}, \code{\link{as.data.frame.PKNCAresults}},
 \code{\link{exclude}}
}
