% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general.functions.R
\name{signifString}
\alias{signifString}
\alias{signifString.data.frame}
\alias{signifString.default}
\title{Round a value to a defined number of significant digits printing out trailing
zeros, if applicable.}
\usage{
signifString(x, digits = 6, si_range = 6)

\method{signifString}{data.frame}(x, digits = 6, si_range = 6)

\method{signifString}{default}(x, digits = 6, si_range = 6)
}
\arguments{
\item{x}{The number to round}

\item{digits}{integer indicating the number of significant digits}

\item{si_range}{integer (or \code{Inf}) indicating when to switch to
scientific notation instead of floating point. Zero indicates always use
scientific; \code{Inf} indicates to never use scientific notation;
otherwise, scientific notation is used when \code{abs(log10(x)) > si_range}.}
}
\value{
A string with the value
}
\description{
Round a value to a defined number of significant digits printing out trailing
zeros, if applicable.
}
\details{
Values that are not standard numbers like \code{Inf}, \code{NA}, and
  \code{NaN} are returned as \code{"Inf"}, \code{"NA"}, and \code{NaN}.
}
\seealso{
\code{\link{signif}}, \code{\link{roundString}}
}
