% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/half.life.R
\name{fit_half_life}
\alias{fit_half_life}
\title{Perform the half-life fit given the data.  The function simply fits
the data without any validation.  No selection of points or any other
components are done.}
\usage{
fit_half_life(data, tlast, conc_units)
}
\arguments{
\item{data}{The data to fit.  Must have two columns named "log_conc"
and "time"}

\item{tlast}{The time of last observed concentration above the limit
of quantification.}

\item{conc_units}{NULL or the units to set for concentration measures}
}
\value{
A data.frame with one row and columns named "r.squared",
  "adj.r.squared", "PROB", "lambda.z", "clast.pred",
  "lambda.z.n.points", "half.life", "span.ratio"
}
\description{
Perform the half-life fit given the data.  The function simply fits
the data without any validation.  No selection of points or any other
components are done.
}
\seealso{
\code{\link{pk.calc.half.life}}
}
