% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-PKNCAresults.R
\name{summary.PKNCAresults}
\alias{summary.PKNCAresults}
\title{Summarize PKNCA results}
\usage{
\method{summary}{PKNCAresults}(
  object,
  ...,
  drop.group = object$data$conc$subject,
  summarize.n.per.group = TRUE,
  not.requested.string = ".",
  not.calculated.string = "NC",
  pretty_names = NULL
)
}
\arguments{
\item{object}{The results to summarize}

\item{...}{Ignored.}

\item{drop.group}{Which group(s) should be dropped from the formula?}

\item{summarize.n.per.group}{Should a column for \code{N} be added
(\code{TRUE} or \code{FALSE})?  Note that \code{N} is maximum number of
parameter results for any parameter; if no parameters are requested for a
group, then \code{N} will be \code{NA}.}

\item{not.requested.string}{A character string to use when a parameter
summary was not requested for a parameter within an interval.}

\item{not.calculated.string}{A character string to use when a parameter
summary was requested, but the point estimate AND spread calculations (if
applicable) returned \code{NA}.}

\item{pretty_names}{Should pretty names (easier to understand in a report) be
used?  \code{TRUE} is yes, \code{FALSE} is no, and \code{NULL} is yes if
units are used an no if units are not used.}
}
\value{
A data frame of NCA parameter results summarized according to the
  summarization settings.
}
\description{
Summarize PKNCA results
}
\details{
Excluded results will not be included in the summary.
}
\examples{
conc_obj <- PKNCAconc(as.data.frame(datasets::Theoph), conc~Time|Subject)
d_dose <- unique(datasets::Theoph[datasets::Theoph$Time == 0,
                                  c("Dose", "Time", "Subject")])
dose_obj <- PKNCAdose(d_dose, Dose~Time|Subject)
data_obj_automatic <- PKNCAdata(conc_obj, dose_obj)
results_obj_automatic <- pk.nca(data_obj_automatic)
# To get standard results run summary
summary(results_obj_automatic)
# To enable numeric conversion and extraction, do not give a spread function
# and subsequently run as.numeric on the result columns.
PKNCA.set.summary(
  name=c("auclast", "cmax", "half.life", "aucinf.obs"),
  point=business.geomean,
  description="geometric mean"
)
PKNCA.set.summary(
  name=c("tmax"),
  point=business.median,
  description="median"
)
summary(results_obj_automatic, not.requested.string="NA")
}
\seealso{
\code{\link{PKNCA.set.summary}}, \code{\link{print.summary_PKNCAresults}}
}
