% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heinzeschemper.R
\name{heinzeschemper}
\alias{heinzeschemper}
\title{Simulate operating characteristics of repaired Cox regression and competitors.}
\usage{
heinzeschemper(
  nobs = 50,
  k = 5,
  B = 1,
  c = 0,
  nsamp = 1000,
  beta = NULL,
  add = NULL,
  half = NULL,
  verbose = FALSE,
  smoothfirst = FALSE
)
}
\arguments{
\item{nobs}{number of observations in simulated data set.}

\item{k}{number of covariates in simulated data set.  Each covariate is dochotomous.}

\item{B}{odds of 1 vs. 0 in dichotomous variables.}

\item{c}{censoring proportion.}

\item{nsamp}{number of samples.}

\item{beta}{regression parameters, all zeros if null, and all the same value if a scalar.}

\item{add}{partial simulation results to be added to, or NULL if de novo.}

\item{half}{does nothing; provided for compatabilitity with simcode.}

\item{verbose}{Triggers verbose messages.}

\item{smoothfirst}{Triggers normal rather than dichotomous interest covariate.}
}
\value{
a list with components
\itemize{
  \item out matrix with columns corresponding to p-values.
}
}
\description{
This function is intended to verify the operating characteristics of the approximate conditional inferential approach of \insertCite{kz19;textual}{PHInfiniteEstimates} to proportional hazards regression.  An exponential regression model, corresponding to the proportional hazards regression model, is fit to the data, and new data sets are simulated from this model.  P-values are calculated for these new data sets, and their empirical distribution is compared to the theoretical uniform distribution.
}
