% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{SimulationFunc}
\alias{SimulationFunc}
\title{SimulationFunc}
\usage{
SimulationFunc(
  data,
  value,
  value_type = 0,
  se,
  repeats = 1e+05,
  confidence = 0.95,
  sqrt_a,
  b_sqrt_a,
  rii = FALSE,
  reliability_stat = FALSE
)
}
\arguments{
\item{data}{data.frame containing the data to calculate SII confidence limits
from; unquoted string; no default}

\item{value}{field name within data that contains the indicator value; unquoted
string; no default}

\item{value_type}{indicates the indicator type (1 = rate, 2 = proportion, 0 = other);
integer; default 0}

\item{se}{field name within data that contains the standard error of the indicator
value; unquoted string; no default}

\item{repeats}{number of random samples to perform to return confidence interval of SII;
numeric; default 100,000}

\item{confidence}{confidence level used to calculate the lower and upper confidence limits of SII;
numeric between 0.5 and 0.9999 or 50 and 99.99; default 0.95}

\item{sqrt_a}{field name within dataset containing square root of a values;
unquoted string; no default}

\item{b_sqrt_a}{field name within dataset containing square root of a values multiplied
by b values;unquoted string; no default}

\item{rii}{option to return the Relative Index of Inequality (RII) with associated confidence limits
as well as the SII; logical; default FALSE}

\item{reliability_stat}{option to carry out the SII confidence interval simulation 10 times instead
of once and return the Mean Average Difference between the first and subsequent samples (as a
measure of the amount of variation); logical; default FALSE}
}
\value{
returns lower and upper SII confidence limits according to user
specified confidence
}
\description{
Function to simulate SII range through random sampling of the indicator value
for each quantile, based on the associated mean and standard error
}
