% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phenthau.R
\name{phenthau}
\alias{phenthau}
\title{Calculate PHENTHAUproc model}
\usage{
phenthau(
  x,
  par_budswelling = "quercus_robur_type1",
  par_leafunfolding = "quercus_robur_type1",
  par_hatch = c("custers", "wagenhoff", "meurisse"),
  def_hatch = "first"
)
}
\arguments{
\item{x}{SpatRaster list/dataframe (tmean, tmax, tmin) - numeric - with time attribute/date column}

\item{par_budswelling}{parametrisation for bud swelling - character}

\item{par_leafunfolding}{parametrisation for leaf unfolding - character}

\item{par_hatch}{parametrisation for hatch - character}

\item{def_hatch}{definition of hatch - character - either "first" or "mean"}
}
\value{
dataframe/list with all PHENTHAUproc model outputs (see details)
}
\description{
"phenthau" implements Halbigs et al. 202x pre-warning system 'PHENTHAUproc' in R
}
\details{
\strong{Overview}

phenthau function combines multiple phenology models:
\itemize{
\item buds welling & leaf unfolding of Quercus robur (or Quercus petraea)
\item hatch of oak processionary moth using 3 different hatch models (Custers 2003, Wagenhoff et al. 2014 and Meurisse et al. 2012)
\item development stages of OPM (0 Egg - 8 Adult)
}

\strong{Parametrisation}

Use parameter() to return a dataframe with all possible parametrisation options.
\itemize{
\item par_budswelling: until now only Quercus robur
\item par_leafunfolding: Quercus robur and Quercus petraea. Should be chosen dependent on dominant oak species in region
\item par_hatch: used hatch models
\item def_hatch: how to calculate hatch. if "first" the first hatch which is predicted by any hatchmodel is taken. If "mean" the mean day of all hatch models is taken.
}

\strong{Output}

phenthau returns a list with all model calculations as list objects:
\itemize{
\item stages: SpatRaster with one layer per day. values from 0-8 0 Egg state 8 Adult stage.
-> use get_legend("stages") to show id/cover/colors
\item custers/wagenhoff/meurisse - logical - TRUE/FALSE hatch/no_hatch
\item budswelling: - logical - TRUE/FALSE budswelling/no_budswelling
\item leafunfolding: - logical - TRUE/FALSE leafunfolding/no_leafunfolding

-> plot first day of a logical SpatRaster with plot_date
\item mortality - integer - mortality in \%
\item ppa_biocide - numeric - 0 application for PPA/biocides not useful yet, 1 application possible, 2 application not useful anymore
}

\strong{Presentation}
\itemize{
\item plot_stages is a wrapper around terra::plot to preset legend, names, colors and day to plot.
\item plot_date is a wrapper around terra::plot to plot the date of first TRUE in multiple layered SpatRaster
\item plot_station is for local weatherstation data and creates a Phenology wheel (ggplot2 & geomtextpath required!)
\item plot_station_step is for local weatherstation data and creates a stepwise graph for the development stages
}
}
\examples{

srl <- load_test()
phen <- phenthau(srl)

}
\references{
Halbig, P. (2021), Model development for hazard assessment of oak
processionary moth (Thaumetopoea processionea). Dissertation, University of Natural Resources and Life Sciences Vienna. 326 S.
}
\seealso{
Other Main: 
\code{\link{get_legend}()},
\code{\link{mortality}()},
\code{\link{parameter}()},
\code{\link{phenology}()}
}
\author{
Bachfischer Lorenz, Department forest protection FVA (2023)
\email{lorenz.bachfischer@posteo.de}
}
\concept{Main}
