% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/55_HELPERS_.R
\name{cat.slice}
\alias{cat.slice}
\title{Slice categorical variable}
\usage{
cat.slice(x, mapping, sc = NA, sc.r = "SC")
}
\arguments{
\item{x}{Character vector to be re-coded.}

\item{mapping}{Data frame with compulsory columns: \code{x.orig} and \code{x.mapp} which represent the mapping
scheme. Column \code{x.orig} should contain unique values of original vector \code{x}, while \code{x.mapp}
should contain corresponding mapping values.}

\item{sc}{Character vector with special case elements. Default value is \code{NA}.}

\item{sc.r}{Character vector used for replacement of special cases. If supplied as one
element vector, it will be recycled to the length of \code{sc}. Default value is \code{"SC"}.}
}
\value{
The command \code{cat.slice} returns vector of re-coded values and special cases.
}
\description{
\code{cat.slice} implements manual re-coding of character vector values for a given mapping scheme.
This procedure is one of the helper functions which are handy for the model monitoring phase
(i.e. after model implementation).
}
\examples{
suppressMessages(library(PDtoolkit))
data(gcd)
x <- gcd$maturity
#artificially add some special values
x[1:5] <- Inf
x[6:7] <- NA
mbin <- cum.bin(x = x, y = gcd$qual, sc.method = "together")
mbin[[1]]
gcd$x <- mbin[[2]]
cb <- cat.bin(x = gcd$x, 
	  y = gcd$qual, 
	  sc = "SC",
	  sc.merge = "none",
	  min.pct.obs = 0.05, 
	  min.avg.rate = 0.05)
x <- gcd$x
mapping <- data.frame(x.orig = x, x.mapp = cb[[2]])\%>\%
       group_by(x.orig, x.mapp) \%>\%
       summarise(n = n(), .groups = "drop")
mapping <- data.frame(mapping[, -3])
sc <- cat.slice(x = x, 
	     mapping = mapping, 
	     sc = NA, 
	     sc.r = "SC")
#compare automatic and manual re-coding
table(cb[[2]], useNA = "always")
table(sc, useNA = "always")
}
