% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/gram_charlier.r
\name{dapx_gca}
\alias{dapx_gca}
\alias{papx_gca}
\title{Approximate density and distribution via Gram-Charlier A expansion.}
\usage{
dapx_gca(x, raw.moments, support=c(-Inf,Inf), log=FALSE)

papx_gca(q, raw.moments, support=c(-Inf,Inf), lower.tail=TRUE, log.p=FALSE)
}
\arguments{
\item{x}{where to evaluate the approximate density.}

\item{raw.moments}{an atomic array of the 1st through kth raw moments
of the probability distribution.}

\item{support}{the support of the density function. It is assumed
that the density is zero on the complement of this open interval.}

\item{log}{logical; if TRUE, densities \eqn{f} are given
as \eqn{\mbox{log}(f)}{log(f)}.}

\item{q}{where to evaluate the approximate distribution.}

\item{log.p}{logical; if TRUE, probabilities p are given
as \eqn{\mbox{log}(p)}{log(p)}.}

\item{lower.tail}{whether to compute the lower tail. If false, we approximate the survival function.}
}
\value{
The approximate density at \code{x}, or the approximate CDF at
\code{q}.
}
\description{
Approximate the probability density or cumulative distribution function of a distribution via its raw moments.
}
\details{
Given the raw moments of a probability distribution, we can approximate the probability
density function, or the cumulative distribution function, via a Gram-Charlier A
expansion on the standardized distribution.

Suppose \eqn{f(x)}{f(x)} is the probability density of some random
variable, and let \eqn{F(x)}{F(x)} be the cumulative distribution function.
Let \eqn{He_j(x)}{He_j(x)} be the \eqn{j}{j}th probabilist's Hermite
polynomial. These polynomials form an orthogonal basis, with respect to the
function \eqn{w(x)}{w(x)} of the Hilbert space of functions which are square
\eqn{w}{w}-weighted integrable. The weighting functimn is
\eqn{w(x) = e^{-x^2/2} = \sqrt{2\pi}\phi(x)}{w(x) = e^{-x^2/2} = sqrt(2pi) phi(x)}.
The orthogonality relationship is
\deqn{\int_{-\infty}^{\infty} He_i(x) He_j(x) w(x) \mathrm{d}x = \sqrt{2\pi} j! \delta_{ij}.}{integral_-inf^inf He_i(x) He_j(x) w(x) dx = sqrt(2pi)j!dirac_ij.}

Expanding the density \eqn{f(x)}{f(x)} in terms of these polynomials in the
usual way (abusing orthogonality) one has
\deqn{f(x) = \sum_{0\le j} \frac{He_j(x)}{j!} \phi(x) \int_{-\infty}^{\infty} f(z) He_j(z) \mathrm{d}z.}{f(x) = sum_{0 <= j} (He_j(x)/j!) phi(x) integral_-inf^inf f(z) He_j(z) dz.}
The cumulative distribution function is 'simply' the integral of this
expansion. Abusing certain facts regarding the PDF and CDF of the normal
distribution and the probabilist's Hermite polynomials, the CDF has
the representation
\deqn{F(x) = \Phi(x) - \sum_{1\le j} \frac{He_{j-1}(x)}{j!} \phi(x) \int_{-\infty}^{\infty} f(z) He_j(z) \mathrm{d}z.}{F(x) = Phi(x) - sum_{1 <= j} (He_{j-1}(x)/j!) phi(x) integral_-inf^inf f(z) He_j(z) dz.}

These series contain coefficients defined by the probability distribution
under consideration. They take the form
\deqn{c_j = \frac{1}{j!}\int_{-\infty}^{\infty} f(z) He_j(z) \mathrm{d}z.}{c_j = (1/j!) integral_-inf^inf f(z) He_j(z) dz.}
Using linearity of the integral, these coefficients are easily computed in
terms of the coefficients of the Hermite polynomials and the raw, uncentered
moments of the probability distribution under consideration. Note that it may be the
case that the computation of these coefficients suffers from bad numerical
cancellation for some distributions, and that an alternative formulation
may be more numerically robust.
}
\note{
Monotonicity of the CDF is not guaranteed.
}
\examples{
# normal distribution:
xvals <- seq(-2,2,length.out=501)
d1 <- dapx_gca(xvals, c(0,1,0,3,0))
d2 <- dnorm(xvals)
d1 - d2

qvals <- seq(-2,2,length.out=501)
p1 <- papx_gca(qvals, c(0,1,0,3,0))
p2 <- pnorm(qvals)
p1 - p2
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
\references{
Jaschke, Stefan R. "The Cornish-Fisher-expansion in the context of
Delta-Gamma-normal approximations." No. 2001, 54. Discussion Papers,
Interdisciplinary Research Project 373: Quantification and Simulation of
Economic Processes, 2001.
\url{http://www.jaschke-net.de/papers/CoFi.pdf}

S. Blinnikov and R. Moessner. "Expansions for nearly Gaussian
distributions." Astronomy and Astrophysics Supplement 130 (1998): 193-205.
\url{http://arxiv.org/abs/astro-ph/9711239}
}
\seealso{
\code{\link{qapx_cf}}
}
\keyword{distribution}

