% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/edgeworth.r
\name{dapx_edgeworth}
\alias{dapx_edgeworth}
\alias{papx_edgeworth}
\title{Approximate density and distribution via Edgeworth expansion.}
\usage{
dapx_edgeworth(x, raw.cumulants, support=c(-Inf,Inf), log=FALSE)

papx_edgeworth(q, raw.cumulants, support=c(-Inf,Inf), lower.tail=TRUE, log.p=FALSE)
}
\arguments{
\item{x}{where to evaluate the approximate density.}

\item{raw.cumulants}{an atomic array of the 1st through kth raw cumulants
of the probability distribution. The first cumulant is the mean, the
second is the variance. The third is \emph{not} the typical unitless skew.}

\item{support}{the support of the density function. It is assumed
that the density is zero on the complement of this open interval.}

\item{log}{logical; if TRUE, densities \eqn{f} are given
as \eqn{\mbox{log}(f)}{log(f)}.}

\item{q}{where to evaluate the approximate distribution.}

\item{log.p}{logical; if TRUE, probabilities p are given
as \eqn{\mbox{log}(p)}{log(p)}.}

\item{lower.tail}{whether to compute the lower tail. If false, we approximate the survival function.}
}
\value{
The approximate density at \code{x}, or the approximate CDF at
\code{q}.
}
\description{
Approximate the probability density or cumulative distribution function of a distribution via its raw cumulants.
}
\details{
Given the raw cumulants of a probability distribution, we can approximate the probability
density function, or the cumulative distribution function, via an Edgeworth
expansion on the standardized distribution. The derivation of the Edgeworth
expansion is rather more complicated than that of the Gram Charlier
approximation, involving the characteristic function and an expression of
the higher order derivatives of the composition of functions; see
Blinnikov and Moessner for more details. The Edgeworth expansion can
be expressed succinctly as
\deqn{\sigma f(\sigma x) = \phi(x) + \phi(x)\sum_{1 \le s}\sigma^s \sum_{\{k_m\}} He_{s+2r}(x) c_{k_m},}{sigma f(sigma x) = phi(x) + phi(x)  sum_{1 <= s} sigma^s sum_{k_m} He_{s+2r}(x) c_{k_m},}
where the second sum is over some partitions, and the constant \eqn{c}
involves cumulants up to order \eqn{s+2}. Unlike the Gram Charlier
expansion, of which it is a rearrangement, the Edgeworth expansion
is arranged in increasing powers of the standard deviation
\eqn{\sigma}{sigma}.
}
\note{
Monotonicity of the CDF is not guaranteed.
}
\examples{
# normal distribution, for which this is silly
xvals <- seq(-2,2,length.out=501)
d1 <- dapx_edgeworth(xvals, c(0,1,0,0,0,0))
d2 <- dnorm(xvals)
d1 - d2

qvals <- seq(-2,2,length.out=501)
p1 <- papx_edgeworth(qvals, c(0,1,0,0,0,0))
p2 <- pnorm(qvals)
p1 - p2
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
\references{
S. Blinnikov and R. Moessner. "Expansions for nearly Gaussian
distributions." Astronomy and Astrophysics Supplement 130 (1998): 193-205.
\url{http://arxiv.org/abs/astro-ph/9711239}
}
\seealso{
the Gram Charlier expansions, \code{\link{dapx_gca}, \link{papx_gca}}
}
\keyword{distribution}

