% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/appx.r
\name{qapx_cf}
\alias{qapx_cf}
\title{Approximate quantile via Cornish-Fisher expansion.}
\usage{
qapx_cf(p, raw.cumulants, lower.tail = TRUE, log.p = FALSE)
}
\arguments{
\item{p}{where to evaluate the approximate distribution.}

\item{raw.cumulants}{an atomic array of the 1st through kth raw cumulants. The first
value is the mean of the distribution, the second should
be the variance of the distribution, the remainder are raw cumulants.}

\item{lower.tail}{whether to compute the lower tail. If false, we approximate the survival function.}

\item{log.p}{logical; if TRUE, probabilities p are given
as \eqn{\mbox{log}(p)}{log(p)}.}
}
\value{
The approximate quantile at \code{x}.
}
\description{
Approximate the quantile function of a distribution via its cumulants.
}
\details{
Given the cumulants of a probability distribution, we approximate the
quantile function via a Cornish-Fisher expansion.
}
\examples{
# normal distribution:
pvals <- seq(0.001,0.999,length.out=501)
q1 <- qapx_cf(pvals, c(0,1,0,0,0,0,0))
q2 <- qnorm(pvals)
q1 - q2
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
\references{
Lee, Y-S., and Lin, T-K. "Algorithm AS269: High Order Cornish Fisher
Expansion." Appl. Stat. 41, no. 1 (1992): 233-240.
\url{http://www.jstor.org/stable/2347649}

Lee, Y-S., and Lin, T-K. "Correction to Algorithm AS269: High Order
Cornish Fisher Expansion." Appl. Stat. 42, no. 1 (1993): 268-269.
\url{http://www.jstor.org/stable/2347433}

AS 269. \url{http://lib.stat.cmu.edu/apstat/269}

Jaschke, Stefan R. "The Cornish-Fisher-expansion in the context of
Delta-Gamma-normal approximations." No. 2001, 54. Discussion Papers,
Interdisciplinary Research Project 373: Quantification and Simulation of
Economic Processes, 2001.
\url{http://www.jaschke-net.de/papers/CoFi.pdf}
}
\seealso{
\code{\link{dapx_gca}, \link{papx_gca}, \link{AS269}, \link{rapx_cf}}
}
\keyword{distribution}

