% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcoa.sig.R, R/print.pcoasig.R, R/scores.pcoasig.R, R/summary.pcoasig.R
\encoding{UTF-8}
\name{pcoa.sig}
\alias{pcoa.sig}
\alias{print.pcoasig}
\alias{scores.pcoasig}
\alias{summary.pcoasig}
\title{Significant dimensions in principal coordinate analysis}
\usage{
pcoa.sig(data, dist = "gower", correction = "none", squareroot = FALSE,
  n.start = NULL, axis = 6, iterations = 1000)

\method{print}{pcoasig}(x, ...)

\method{scores}{pcoasig}(x, choices = c(1, 2), ...)

\method{summary}{pcoasig}(object, ...)
}
\arguments{
\item{data}{Community data matrix.}

\item{dist}{Dissimilarity index, as accepted by \code{\link{vegdist}} (Default dist="gower").}

\item{correction}{Correction methods for negative eigenvalues, as accepted by \code{\link{pcoa}}: 
"lingoes" and "cailliez" (Default correction="none").}

\item{squareroot}{Logical argument (TRUE or FALSE) to specify if use square root of dissimilarity 
index (Default squareroot = FALSE).}

\item{n.start}{Initial sample size. One sampling unit is added at each sampling step. If n.start = NULL 
initial sample size is equal to total sample size (Default n.start=NULL).}

\item{axis}{Maximum number of ordination principal axes to be monitored (Default axis=6).}

\item{iterations}{Number of permutations to assess significance (Default iterations=1000).}

\item{x}{An object of class pcoasig.}

\item{...}{Other parameters for the respective functions.}

\item{choices}{Axes for re-scaling. Choices must have length equal to two (Default choices = c(1,2)).}

\item{object}{An object of class pcoasig.}
}
\value{
\item{PCoA}{PCoA result, exactly as returned for the pcoa function.}  \item{correlations}{Correlations
between axis and original data.} \item{mean.cor.null}{Mean correlations, for axis, between null and reference
scores.} \item{mean.cor.bootstrap}{Mean correlations, for axis, between bootstrap and reference scores.}
\item{cumulative.frequency}{Cumulative frequency in which the null correlations were greater than the bootstrap
correlation.} \item{n.permut.bootstrap}{Number of iterations for each axis in bootstrap step.}
\item{n.permut.null}{Number of iterations for each axis in null step.} \item{probabilities}{Probabilities for each axis.}
}
\description{
Function for determine the number of significant dimensions in principal coordinate analysis (PCoA).
}
\details{
At each iteration step a bootstrap sample is subjected to PCoA ordination, the scores are submitted 
to a procrustean adjustment, and the correlation between observed and bootstrap ordination scores 
is computed. It compares such correlations to the same parameter generated in a parallel bootstrapped
ordination of randomly permuted data. The number of axes in bootstrap or null PCoA with eigenvectors 
corresponding to positive eigenvalues may be smaller than the number of axes monitored, in this case, 
axes with values equal to 0 are created. The number of iterations with original values for each axis 
is shown in n.permut.bootstrap and n.permut.null.

The function scores.pcoasig re-scales the correlation values for \code{\link{biplot}} graphics.
}
\note{
\strong{Principal Component Analysis (PCA)}

You can use the same function to determine the number of significant dimensions in principal component 
analysis (PCA). For this, standardize each variable for zero mean and uni variance (function decostand
and method standardize) and use euclidean distance as dissimilarity index.

\strong{Interpretation}

If the higher dimension is significant, then all lower dimensions will also be significant.
}
\examples{

data(flona)
res<-pcoa.sig(flona$community, axis = 6, dist = "bray", iterations = 100)
res
summary(res)

}
\author{
Vanderlei Julio Debastiani <vanderleidebastiani@yahoo.com.br>
}
\references{
Pillar, V.D. (1999). The bootstrapped ordination reexamined. Journal of Vegetation Science 10, 895-902.
}
\seealso{
\code{\link{pcoa}}, \code{\link{procrustes}}
}
\keyword{PCPS}

