% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCM.R
\name{PCMLik}
\alias{PCMLik}
\title{Likelihood of a multivariate Gaussian phylogenetic comparative model with non-interacting lineages}
\usage{
PCMLik(X, tree, model, metaI = PCMInfo(X, tree, model, verbose =
  verbose), log = TRUE, verbose = FALSE)
}
\arguments{
\item{X}{a \code{k x N} numerical matrix with possible \code{NA} and \code{NaN} entries. Each
column of X contains the measured trait values for one species (tip in tree).
Missing values can be either not-available (\code{NA}) or not existing (\code{NaN}).
Thse two values have are treated differently when calculating
likelihoods: see \code{\link{PCMPresentCoordinates}}.}

\item{tree}{a phylo object with N tips.}

\item{model}{an S3 object specifying both, the model type (class, e.g. "OU") as
well as the concrete model parameter values at which the likelihood is to be
calculated (see also Details).}

\item{metaI}{a list returned from a call to \code{PCMInfo(X, tree, model)},
containing meta-data such as N, M and k.}

\item{log}{logical indicating whether a log-liklehood should be calculated. Default
is TRUE.}

\item{verbose}{logical indicating if some debug-messages should printed.}
}
\value{
a numerical value with named attributes as follows:
\describe{
\item{X0}{A numerical vector of length k specifying the value at the root for which
the likelihood value was calculated. If the model contains a member called X0, this
vector is used; otherwise the value of X0 maximizing the likelihood for the given
model parameters is calculated by maximizing the quadratic polynomial
'X0 * L_root * X0 + m_root * X0 + r_root'.}
\item{error}{A named list containing error information if a numerical or other
logical error occured during likelihood calculation (this is a list returned by
 \code{\link{PCMParseErrorMessage}}.}
 If an error occured during likelihood calculation, the default behavior is to
 return NA with a non-NULL error attribute. This behavior can be changed in
 using global options:
 \item{"PCMBase.Value.NA"}{Allows to specify a different NA value such as \code{-Inf} or \code{-1e20} which can be used in compbination with \code{log = TRUE} when
  using \code{optim} to maximize the log-likelihood;}
 \item{"PCMBase.Errors.As.Warnings"}{Setting this option to FALSE will cause any
 error to result in calling the \code{\link{stop}} R-base function. If not caught
 in a \code{\link{tryCatch}}, this will cause the inference procedure to abort at the occurence of a numerical error. By default, this option is set to TRUE, which
 means that \code{getOption("PCMBase.Value.NA", as.double(NA))} is returned with
 an error attribute and a warning is issued.}
}
}
\description{
The likelihood of a PCM represets the probability density function
  of observed trait values (data) at the tips of a tree given the tree and
  the model parameters. Seen as a function of the model parameters, the
  likelihood is used to fit the model to the observed trait data and the
  phylogenetic tree (which is typically inferred from another sort of data, such
  as an alignment of genetic sequences for the species at the tips of the tree).
  The \code{\link{PCMLik}} function
  provides a common interface for calculating the (log-)likelihood of different
  PCMs.
  Below we denote by N the number of tips, by M the total number of nodes in the
  tree including tips, internal and root node, and by k - the number of traits.
}
\details{
For efficiency, the argument \code{metaI}
  can be provided explicitly, because this is not supposed to change during a
  model inference procedure such as likelihood maximization.
}
\seealso{
\code{\link{PCMInfo}} \code{\link{PCMAbCdEf}} \code{\link{PCMLmr}} \code{\link{PCMSim}} \code{\link{PCMCond}} \code{\link{PCMParseErrorMessage}}
}
