% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCM.R
\name{PCM}
\alias{PCM}
\title{Create a phylogenetic comparative model object}
\usage{
PCM(model, modelTypes = class(model)[1], k = 1L, regimes = 1L,
  params = NULL, vecParams = NULL, offset = 0L, spec = NULL, ...)
}
\arguments{
\item{model}{This argument can take one of the following forms:
\itemize{
\item a character vector of the S3-classes of the model object to be
created (one model object can have one or more S3-classes, with the class
PCM at the origin of the hierarchy);
\item an S3 object which's class inherits from the PCM S3 class.
}
The Details section explains how these two types of input are processed.}

\item{modelTypes}{a character string vector specifying a set (family) of
model-classes, to which the constructed model object belongs. These are used
for model-selection.}

\item{k}{integer denoting the number of traits (defaults to 1).}

\item{regimes}{a character or integer vector denoting the regimes.}

\item{params}{NULL (default) or a list of parameter values (scalars, vectors,
matrices, or arrays) or sub-models (S3 objects inheriting from the PCM class).
See details.}

\item{vecParams}{NULL (default) or a numeric vector the vector
representation of the variable parameters in the model. See details.}

\item{offset}{integer offset in vecParams; see Details.}

\item{spec}{NULL or a list specifying the model parameters (see \code{\link{PCMSpecify}}). If NULL (default), the generic PCMSpecify
is called on the created object of class \code{model}.}

\item{...}{additional parameters intended for use by sub-classes of the PCM
class.}
}
\value{
an object of S3 class as defined by the argument model.
}
\description{
This is the entry-point function for creating model objects within
the PCMBase framework representing a single model-type with one or several
model-regimes of this type associated with the branches of a tree. For mixed
Gaussian phylogenetic models, which enable multiple model-types, use the
\code{\link{MixedGaussian}} function.
}
\details{
This is an S3 generic. The PCMBase package defines three methods for
it:
\itemize{
\item{PCM.PCM:}{A default constructor for any object with a class inheriting
from "PCM".}
\item{PCM.character:}{A default PCM constructor from a character string
specifying the type of model.}
\item{PCM.default:}{A default constructor called when no other constructor is
found. When called this constructor raises an error message.}
}
}
\examples{
# a Brownian motion model with one regime
modelBM <- PCM(model = "BM", k = 2)
# print the model
modelBM

# a BM model with two regimes
modelBM.ab <- PCM("BM", k = 2, regimes = c("a", "b"))
modelBM.ab

# print a single parameter of the model (in this case, the root value)
modelBM.ab$X0

# assign a value to this parameter (note that the brackets [] are necessary
# to preserve  the parameter attributes):
modelBM.ab$X0[] <- c(5, 2)

PCMNumTraits(modelBM)
PCMNumRegimes(modelBM)
PCMNumRegimes(modelBM.ab)

# number of numerical parameters in the model
PCMParamCount(modelBM)

# Get a vector representation of all parameters in the model
PCMParamGetShortVector(modelBM)

# Limits for the model parameters:
lowerLimit <- PCMParamLowerLimit(modelBM)
upperLimit <- PCMParamUpperLimit(modelBM)

# assign the model parameters at random: this will use uniform distribution
# with boundaries specified by PCMParamLowerLimit and PCMParamUpperLimit
# We do this in two steps:
# 1. First we generate a random vector. Note the length of the vector equals PCMParamCount(modelBM)
randomParams <- PCMParamRandomVecParams(modelBM, PCMNumTraits(modelBM), PCMNumRegimes(modelBM))
randomParams
# 2. Then we load this random vector into the model.
PCMParamLoadOrStore(modelBM, randomParams, 0, PCMNumTraits(modelBM), PCMNumRegimes(modelBM), TRUE)

print(modelBM)

PCMParamGetShortVector(modelBM)

# generate a random phylogenetic tree of 10 tips
tree <- ape::rtree(10)

#simulate the model on the tree
traitValues <- PCMSim(tree, modelBM, X0 = modelBM$X0)

# calculate the likelihood for the model parameters, given the tree and the trait values
PCMLik(traitValues, tree, modelBM)

# create a likelihood function for faster processing for this specific model.
# This function is convenient for calling in optim because it recieves and parameter
# vector instead of a model object.
likFun <- PCMCreateLikelihood(traitValues, tree, modelBM)
likFun(randomParams)
}
\seealso{
\code{\link{MixedGaussian}}
}
