% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCM.R
\name{PCMListParameterizations}
\alias{PCMListParameterizations}
\alias{PCMListDefaultParameterizations}
\title{Specify the parameterizations for each parameter of a model}
\usage{
PCMListParameterizations(model, ...)

PCMListDefaultParameterizations(model, ...)
}
\arguments{
\item{model}{a PCM.}

\item{...}{additional arguments used by implementing methods.}
}
\value{
a named list with list elements corresponding to each parameter in
model. Each list element is a list of character vectors, specifying the possible
S3 class attributes for the parameter in question. For an example, type
`PCMListParameterizations.BM` to see the possible parameterizations for the
BM model.
}
\description{
These are S3 generics. `PCMListParameterizations` should return
all possible parametrizations for the class of `model`.
`PCMListDefaultParameterizations` is a handy way to specify a subset of all
parametrizations. `PCMListDefaultParameterizations` should be used to avoid
generating too many model parametrizations which occupy space in the R-global
environment while they are not used (see \link{PCMGenerateParameterizations}).
It is mandatory to implement a specification for `PCMListParameterizations`
for each newly defined class of models.
`PCMListDefaultParameterizations` has a default implementation that calls
`PCMListParameterizations` and returns the first parametrization for each
parameter. Hence, implementing a method for `PCMListDefaultParameterizations`
for a newly defined model type is optional.
}
\seealso{
PCMGenerateParameterizations
}
