% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plotter.R
\name{PCA.Plotter}
\alias{PCA.Plotter}
\title{PCA.Plotter}
\usage{
PCA.Plotter(data.mat)
}
\arguments{
\item{data.mat}{a numeric matrix or data frame. Long, wide and squared matrix supported. NAs supported. Variance required for all variables.}
}
\description{
Makes the basic PCA plots on a given matrix. Scores and loadings scatterplots of PC1 vs PC2.
Centers and UV-scales the variables, makes a 2 component PCA. Supports NAs but requires variance
in all variables. Presents R2 for each component. Uses the package "mixOmics". Rownames/colnames
are used as point labels.
}
\examples{
set.seed(5)
num.of.variables <- 14
num.of.observations <- 34
rn <- rnorm(num.of.variables * num.of.observations)
data.mat <- matrix(rn, nrow = num.of.observations, ncol = num.of.variables)
PCA.Plotter(data.mat)
}
\author{
Berntsson, Martin <martin.berntsson@eon.se> and de Saint-Aubain, Philip Anton <philip-anton.desaint-aubain@knowit.dk>
}
