% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_errors.R
\name{test_errors}
\alias{test_errors}
\title{Compare numeric variables in a data frame based on root-squared differences}
\usage{
test_errors(reference, target, vars, tolerance = 0.001005,
  return_logical = TRUE)
}
\arguments{
\item{reference}{a data frame giving reference data}

\item{target}{a data frame giving target data}

\item{vars}{character vector of variable names to compare in each data frame}

\item{tolerance}{allowable difference between numeric values}

\item{return_logical}{logical. Should result be given as a logical vector
(indicating TRUE/FALSE equality within tolerance) or a data frame of error
summary values?}
}
\value{
If \code{return_logical = TRUE}, a named logical vector with one
  element per variable compared, indicating whether the maximum and
  root-mean-squared differences fall within the tolerance. If
  \code{return_logical = FALSE}, a data frame indicating the variables
  compared and the maximum and root-mean-squared differences.
}
\description{
Compare numeric variables in a data frame based on root-squared differences
}
\note{
It is assumed that \code{reference} and \code{target} have equal
  numbers of rows.
}
\examples{
reference <- data.frame(
a = 1:100, b = 75:174
)

target <- data.frame(
  a = 0.001 + (1:100),
  b = 76:175
)

test_errors(reference, target, c("a", "b"))
test_errors(reference, target, c("a", "b"), return_logical = FALSE)
}
