% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.R
\name{residualsAcat}
\alias{residualsAcat}
\title{This is a function to deal with the vglm object in S4.}
\usage{
residualsAcat(
  object,
  type = c("surrogate", "sign", "general", "deviance"),
  jitter = c("latent", "uniform"),
  jitter.uniform.scale = c("probability", "response"),
  nsim = 1L,
  ...
)
}
\arguments{
\item{object}{An object of class \code{\link[VGAM]{vglm}}.}

\item{type}{The type of residuals which should be returned. The alternatives
are: "surrogate" (default), "sign", "general", and "deviance". Can be abbreviated.
\describe{
  \item{\code{surrogate}}{surrogate residuals (Liu and Zhang, 2017);}
  \item{\code{sign}}{sign-based residuals;}
  \item{\code{general}}{generalized residuals (Franses and Paap, 2001);}
  \item{\code{deviance}}{deviance residuals (-2*loglik).}
}}

\item{jitter}{A character string specifying which method to use to generate the
surrogate response values. Current options are \code{"latent"} and
\code{"uniform"}. Default is \code{"latent"}.
\describe{
  \item{\code{latent}}{latent approach;}
  \item{\code{uniform}}{jittering uniform approach.}
}}

\item{jitter.uniform.scale}{A character string specifying the scale on which to perform
the jittering whenever \code{jitter = "uniform"}. Current options are
\code{"response"} and \code{"probability"}. Default is \code{"response"}.}

\item{nsim}{An integer specifying the number of replicates to use.
Default is \code{1L} meaning one simulation only of residuals.}

\item{...}{Additional optional arguments.}
}
\value{
A "resid" object with attributes. It contains a vector or a matrix (nsim>1) of
residuals for the adjacent categories model.
}
\description{
This is a function to deal with the vglm object in S4.
}
\keyword{internal}
