% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SLI_summary.R
\name{SLI}
\alias{SLI}
\title{Standing/Light Intensity Physical Activity Summary}
\usage{
SLI(final_dat, bed_time, takeoff_time)
}
\arguments{
\item{final_dat}{Raw event file, will be cleaned in this function. Event file is required for this function.}

\item{bed_time}{Sleep and wake up time log, reported by participants. Log is not required for this function.}

\item{takeoff_time}{Take on and off time log, reported by participants. Log is not required for this function.}
}
\value{
\code{Year} The calendar year of recorded event

\code{Month} The calendar month of recorded event

\code{Day}   The calendar day of recorded event

\code{Dayofweek} The day of that week

\code{Weekday_or_weekend}  The recored event date is a weekday or weekend (0 for weekday, 1 for weekend)

\code{total_number_of_activity_bouts} Total events that are standing or stepping

\code{total_number_of_activity_bouts} Total number of events that are standing or stepping

\code{mean_activity_bout_length} Average length of activity bout

\code{prop_of_activity_time_greater_5min} The ratio of the number of active bouts greater than 5 min to the total number of active events

\code{prop_of_activity_time_greater_10min} The ratio of the number of active bouts greater than 10 min to the total number of active events.

\code{prop_of_activity_time_greater_30min} The ratio of the number of active bouts greater than 30 min to the total number of active events.

\code{total_activity_time_greater_5min} The summation of the active durations which are greater than 5 min

\code{total_activity_time_greater_10min} The summation of the active durations which are greater than 10 min

\code{total_activity_time_greater_30min} The summation of the active durations which are greater than 30 min

\code{percentile_activity_time_5} 5\% percentile of activity bouth length

\code{percentile_activity_time_25} 25\% percentile of activity bout length

\code{percentile_activity_time_50} 50\% percentile of activity bout length

\code{percentile_activity_time_75} 75\% percentile of activity bout length

\code{percentile_activity_time_95} 95\% percentile of activity bout length

\code{alpha_activity} alpha of activity time, see details

\code{stepping_to_standing_ratio} Ratio of stepping to standing, the ratio of total stepping hours to standing hours
}
\description{
Summarize standing and light intensity activity measures
}
\details{
\code{alpha_activity} is defined by \code{1+1/M}, where \code{M} is the average of \code{log(activity bout length /minimum activity bout length)}
}
\examples{
#For CRAN less than 5s running time policy, we only select the first day to run.
r4=SLI(sample_event[1:3095,],sample_bed_time[1,],sample_takeon_log[1,])
summary(r4)
}

