% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{data}
\name{EURD}
\alias{EURD}
\title{European Union Research and Development}
\format{A data frame with 15 observations on the following 3 variables:
\itemize{
\item \code{country} (a character vector with values \code{Bulgaria}, \code{Croatia}, \code{Cyprus}, \code{Czech Republic}, \code{Estonia}, \code{France}, \code{Hungary}, \code{Latvia}, \code{Lithuania}, \code{Malta}, \code{Portugal}, \code{Romania}, \code{Slovakia}, and \code{Slovenia})
\item \code{rd2002} (research and development investments in millions of Euros for 2002)
\item \code{rd2003} (research and development investments in millions of Euros for 2003)
}}
\usage{
EURD
}
\description{
A random sample of 15 countries' research and development investments for the years 2002 and 2003 was taken, and the results in millions of Euros are stored in \code{EURD}.
}
\examples{
ggplot(data = EURD, aes(x = rd2002, y =  rd2003)) + geom_point() +
geom_smooth(method = "lm")
ggplot(data = EURD, aes(sample = rd2003 - rd2002)) + stat_qq()
# lattice approach
qqmath(~ (rd2003 - rd2002), data = EURD, type =c("p", "r"))
}
\references{
Ugarte, M. D., Militino, A. F., and Arnholt, A. T. 2015. \emph{Probability and Statistics with R}, Second Edition. Chapman & Hall / CRC.
}
\keyword{datasets}

