% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AgainStart.R
\docType{data}
\name{PAMTEMP}
\alias{PAMTEMP}
\title{Pamplona Temperatures}
\format{A data frame with 7547 observations on the following 7 variables: 
\itemize{
\item \code{tmax} (maximum daily temperature in Celsius)
\item \code{tmin} (minimum daily temperature in Celsius)
\item \code{precip} (daily precipitation in mm)
\item \code{day} (day of the month)
\item \code{month} (month of the year)
\item \code{year} (year)
\item \code{tmean} (the average of \code{tmax} and \code{tmin})
}}
\usage{
PAMTEMP
}
\description{
The data frame \code{PAMTEMP} has records of the temperature and precipitation for Pamplona, Spain from January 1, 1990 to December 31, 2010.
}
\examples{
str(PAMTEMP)
levels(PAMTEMP$month)
PAMTEMP$month <- factor(PAMTEMP$month, levels = month.abb[1:12])
levels(PAMTEMP$month)
ggplot(data = PAMTEMP, aes(x = 1:dim(PAMTEMP)[1], y = tmean)) + 
geom_line() + 
theme_bw() + 
labs(x = "", y = "Average Temperature (Celcius)")
}
\references{
Ugarte, M. D., Militino, A. F., and Arnholt, A. T. 2015. \emph{Probability and Statistics with R}, Second Edition. Chapman & Hall / CRC.
}
\keyword{datasets}

