% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AgainStart.R
\docType{data}
\name{CARS2004}
\alias{CARS2004}
\title{Cars in the European Union (2004)}
\format{A data frame with 25 observations on the following 4 variables: 
\itemize{
\item \code{country} (a factor with levels \code{Austria}, \code{Belgium}, \code{Cyprus}, \code{Czech Republic}, \code{Denmark}, \code{Estonia}, \code{Finland}, \code{France}, \code{Germany}, \code{Greece}, \code{Hungary}, \code{Ireland}, \code{Italy}, \code{Latvia}, \code{Lithuania}, \code{Luxembourg}, \code{Malta}, \code{Netherlands}, \code{Poland}, \code{Portugal}, \code{Slovakia}, \code{Slovenia}, \code{Spain}, \code{Sweden}, and \code{United Kingdom})
\item \code{cars} (number of cars per 1000 inhabitants)
\item \code{deaths} (total number of known mortal accidents) 
\item \code{population} (country population/1000)
}}
\usage{
CARS2004
}
\description{
The numbers of cars per 1000 inhabitants (\code{cars}), the total number of known mortal accidents (\code{deaths}), and the country  population/1000 (\code{population}) for the 25 member countries of the European Union for the year 2004
}
\examples{
plot(deaths ~ cars, data = CARS2004)
ggplot(data = CARS2004, aes(x = population, y = deaths, color = cars)) + geom_point()
}
\references{
Ugarte, M. D., Militino, A. F., and Arnholt, A. T. 2015. \emph{Probability and Statistics with R}, Second Edition. Chapman & Hall / CRC.
}
\keyword{datasets}

