% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_Gamma.R
\name{power_Gamma}
\alias{power_Gamma}
\title{Power Calculations for Test of Two Gamma Means}
\usage{
power_Gamma(n1 = NULL, n2 = NULL, power = NULL, sig.level = 0.05, 
mu1 = NULL, mu2 = NULL, gmu1 = NULL, gmu2 = NULL,
trials = 100, M = 10000, equal.sample = TRUE, equal.shape = NULL)
}
\arguments{
\item{n1}{sample size in group 1, or sample size in each group if equal.sample = TRUE}

\item{n2}{sample size in group 2}

\item{power}{power of test (1 minus Type II error probability)}

\item{sig.level}{significance level (Type I error probability)}

\item{mu1}{arithmetic mean of group 1}

\item{mu2}{arithmetic mean of group 2}

\item{gmu1}{geometric mean of group 1}

\item{gmu2}{geometric mean of group 2}

\item{trials}{number of trials in simulation}

\item{M}{number of simulations used in CAT method, see Chang (2011)}

\item{equal.sample}{equal sample sizes for two groups, see details}

\item{equal.shape}{assume the shape parameters are equal for two groups, see details}
}
\value{
Object of class "power.htest", a list of the arguments (including the computed one) augmented with method element.
}
\description{
Compute the power for a test of two sample means with Gamma distributions, or determine parameters to obtain a target power.
}
\details{
Exactly one of the parameters \code{n1}, \code{n2}, and \code{power} must be passed as NULL, and that parameter is determined from the others.
Notice that \code{sig.level} has non-NULL defaults, so NULL must be explicitly passed if you want to compute it.\cr\cr
If \code{equal.sample = TRUE} is used, N in output will denote the number in each group.\cr\cr
The equal shape parameter assumption will be tested automatically; otherwise it could be set manually with \code{equal.shape}.
}
\examples{
# Calculate power, equal sizes
power_Gamma(n1 = 50, mu1 = 1, mu2 = 1.5, gmu1 = 0.6, gmu2 = 0.6, M = 100)
}
\references{
Chang et al. (2011). Testing the equality of several gamma means: a parametric bootstrap method with applications. \emph{Computational Statistics}, \bold{26}:55-76.
}
