% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PANPRS_gsfPEN.R
\name{gsfPEN_R}
\alias{gsfPEN_R}
\title{Run the gsfPEN algorithm for multiple traits, with functional annotations.}
\usage{
gsfPEN_R(
  summary_z,
  n_vec,
  plinkLD,
  func_index,
  n_iter = 1000,
  upper_val = NULL,
  breaking = 1,
  z_scale = 1,
  tuning_matrix = NULL,
  p_threshold = NULL,
  p_threshold_params = c(0.5, 10^-4, 4),
  tau_factor = c(1/25, 1, 3),
  sub_tuning = 4,
  lim_lambda = c(0.5, 0.9),
  len_lambda = 4,
  lambda_vec = NULL,
  lambda_vec_limit_len = c(1.5, 3),
  df_max = NULL,
  sparse_beta = FALSE,
  debug_output = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{summary_z}{A matrix of summary statistics for each SNP and trait.}

\item{n_vec}{A vector of sample sizes for each of the Q traits corresponding to the Q columns of summary_z.}

\item{plinkLD}{A matrix of LD values for each pair of SNPs.}

\item{func_index}{A matrix of functional annotations for each SNP and trait. For the element at i-th row, j-th column, the entry 0 means SNP i without j-th functional annotation; entry 1 means otherwise.}

\item{n_iter}{The number of iterations to run the algorithm.}

\item{upper_val}{The upper bound for the tuning parameter.}

\item{breaking}{The number of iterations to run before checking for convergence.}

\item{z_scale}{The scaling factor for the summary statistics.}

\item{tuning_matrix}{A matrix of tuning parameters.}

\item{p_threshold}{A vector of p-values to use for the tuning parameters.}

\item{p_threshold_params}{A vector of parameters to use for the p-value tuning parameters.}

\item{tau_factor}{A vector of factors to multiply the median value by to get the tuning parameters.}

\item{sub_tuning}{The number of tuning parameters to use for the second iteration.}

\item{lim_lambda}{The range of tuning parameters to use for the first iteration.}

\item{len_lambda}{The number of tuning parameters to use for the second iteration.}

\item{lambda_vec}{A vector of tuning parameters to use for the first iteration.}

\item{lambda_vec_limit_len}{The number of tuning parameters to use for the first iteration.}

\item{df_max}{The maximum degrees of freedom for the model.}

\item{sparse_beta}{Whether to use the sparse version of the algorithm.}

\item{debug_output}{Whether to output the tuning combinations that did not converge.}

\item{verbose}{Whether to output information through the evaluation of the algorithm.}
}
\value{
A named list containing the following elements:
beta_matrix: A matrix of the estimated coefficients for each SNP and trait.
num_iter_vec: A vector of the number of iterations for each tuning combination.
all_tuning_matrix: A matrix of the tuning parameters used for each tuning combination.
}
\description{
Run the gsfPEN algorithm for multiple traits, with functional annotations.
}
\examples{
# Load the library and data
library(PANPRSnext)
data("summaryZ")
data("Nvec")
data("plinkLD")
data("funcIndex")

# Take random subset of the data
subset <- sample(nrow(summaryZ), 100)
subset_summary_z <- summaryZ[subset, ]
subset_func_index <- funcIndex[subset, ]

# Run gsfPEN
output <- gsfPEN_R(
  summary_z = subset_summary_z,
  n_vec = Nvec,
  plinkLD = plinkLD,
  func_index = subset_func_index
)
}
