% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matchTimeData.R
\name{matchTimeData}
\alias{matchTimeData}
\alias{timeJoin}
\title{Match time-based data to PAMpal objects}
\usage{
matchTimeData(
  x,
  data,
  mode = c("event", "detection"),
  thresh = Inf,
  interpolate = TRUE,
  replace = FALSE,
  keepDiff = FALSE
)

timeJoin(x, y, thresh = Inf, interpolate = TRUE, replace = FALSE)
}
\arguments{
\item{x}{\linkS4class{AcousticStudy} or \linkS4class{AcousticEvent} object
to match data to, or a dataframe for \code{timeJoin}}

\item{data}{a data frame to match to data to \code{x}.
Must have column \code{UTC}, and optionally a column \code{db} if subsets
of data should be matched only to parts of \code{x} with that database. All
other columns will be considered variables to add to \code{x}}

\item{mode}{one of "event" or "detection". "event" will match one set of
variables per event, stored in the "measures" for that event. "detection"
will match variables to every detection.}

\item{thresh}{maximum time apart in seconds for matching to
data, if the closest value is more than \code{thresh} apart then the
variable values will be set to \code{NA}}

\item{interpolate}{logical flag whether or not to interpolate between points
in \code{data} or just matched to nearest time}

\item{replace}{one of \code{TRUE}, \code{FALSE}, or \code{NA}. If \code{TRUE},
all existing values with the same name as columns in \code{data} will be
replaced. If \code{FALSE} no replacement occurs. If \code{NA} only values
which are \code{NA} will be replaced with new values}

\item{keepDiff}{logical flag to keep time difference data}

\item{y}{dataframe to join to \code{x}}
}
\value{
the same data as \code{x}, with data added from \code{data}
}
\description{
Match any time-based data (dataframe with a \code{UTC} column)
  to an AcousticStudy or AcousticEvent object
}
\details{
This function lets you match any arbitrary data to a PAMpal object
  as long as it has a time associated with it. Data will be attached to
  detector dataframes for \code{mode='detection'} or to the event "measures"
  location for \code{mode='event'} (this is where \link{calculateICI} and
  \link{matchEnvData} store their event data). These can be accessed with the
  \link{getMeasures} function and are also exported in the various "getXXX"
  functions (\link{getClickData} etc.) if \code{measures=TRUE} (default).

  All columns in the provided \code{data} object will be treated as variables
  to add, with a few exceptions. There are a few reserved column names used by
  PAMpal that cannot be overridden (e.g. UID, eventId, species). Also any columns
  already existing in the PAMpal data will not be overridden unless \code{replace}
  is not \code{FALSE}. The column names in \code{data} will be used as the names
  for the added variables, so care should be taken to ensure these are informative
  enough for future use.
}
\examples{

data(exStudy)
addData <- data.frame(UTC = as.POSIXct('2018-03-20 15:25:10', tz='UTC'),
                      newVariable = 26)
data <- matchTimeData(exStudy, addData, mode='detection')
getClickData(data)
data <- matchTimeData(exStudy, addData, mode='event')
getMeasures(data)

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
