% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncToData.R
\name{ncToData}
\alias{ncToData}
\title{Match Data From a Netcdf File}
\usage{
ncToData(
  data,
  nc,
  buffer = c(0, 0, 0),
  FUN = c(mean),
  raw = FALSE,
  keepMatch = TRUE,
  progress = TRUE,
  depth = 0,
  verbose = TRUE
)
}
\arguments{
\item{data}{dataframe containing Longitude, Latitude, and UTC to extract matching
variables from the netcdf file}

\item{nc}{name of a netcdf file}

\item{buffer}{vector of Longitude, Latitude, and Time (seconds) to buffer around
each datapoint. All values within the buffer will be used to report the mean,
median, and standard deviation}

\item{FUN}{a vector or list of functions to apply to the data. Default is to apply
mean, median, and standard deviation calculations}

\item{raw}{logical flag to return only the raw values of the variables. If \code{TRUE}
the output will be changed to a list with length equal to the number of data points.
Each item in the list will have separate named entries for each variable that will have
all values within the given buffer and all values for any Z coordinates present.}

\item{keepMatch}{logical flag to keep the matched coordinates, these are useful to make sure
the closest point is actually close to your XYZT}

\item{progress}{logical flag to show progress bar for matching data}

\item{depth}{depth values (meters) to use for matching, overrides any \code{Depth} column
in the data or can be used to specify desired depth range when not present in data.
Variables will be summarised over the range of these depth values. \code{NULL}
uses all available depth values}

\item{verbose}{logical flag to show warning messages for possible coordinate mismatch}
}
\value{
original dataframe with three attached columns for each variable in the netcdf
  file, one for each of mean, median, and standard deviation of all values within the buffer
}
\description{
Extracts all variables from a netcdf file matching Longitude,
  Latitude, and UTC coordinates in given dataframe
}
\examples{

data <- data.frame(Latitude = 32, Longitude = -117,
                   UTC = as.POSIXct('2005-01-01 00:00:00', tz='UTC'))
nc <- system.file('extdata', 'sst.nc', package='PAMmisc')
# default calculates mean
ncToData(data, nc = nc)
# calculate mean, median, and sd
ncToData(data, nc=nc, FUN=c(mean, median, sd), buffer = c(.01, .01, 86400))
# custom function
meanPlusOne <- function(x) {
    mean(x, na.rm=TRUE) + 1
}
ncToData(data, nc=nc, FUN=c(mean, meanPlusOne))

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
