% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BARDM.B.R
\name{BARDM.B}
\alias{BARDM.B}
\title{This function implements Bayesian inference of BARD-Mallows model.}
\usage{
BARDM.B(datfile, nRe, iter = 1000)
}
\arguments{
\item{datfile}{A matrix or dataframe. This is the data where our algorithm will work on. Each colomn denotes a ranker's ranking. The data should be in entity-based format.}

\item{nRe}{A number. Number of relevant entities}

\item{iter}{A number. Numner of iterations of MCMC}
}
\value{
List. It contains Bayesian posterior samples of all the parameters and log-likelihood.
\enumerate{
  \item I.mat: posterior samples of I
  \item phi.mat: posterior samples of phi
  \item smlgamma.mat: posterior samples of gamma
  \item l.mat: posterior samples of log-likelihood
}
}
\description{
This function implements Bayesian inference of BARD-Mallows model.
}
\examples{
dat=t(PerMallows::rmm(10,1:20,0.5))
BARDM.B(dat,10,iter=10)
\donttest{BARDM.B(dat,10,iter=1000)}
}
