% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualisation.R
\name{draw_network}
\alias{draw_network}
\title{Draw network of enriched functional annotation pairs}
\usage{
draw_network(graph, pval = 0.05, adjMethod = NULL, seed = 123)
}
\arguments{
\item{graph}{The output of either the pafway or pafway_edge_weight functions}

\item{pval}{The threshold of p-value at which to draw an arrow}

\item{adjMethod}{The method for correcting for multiple hypotheses.  This can be any method that is acceptable to the p.adjust function in the stats package: "holm", "hochberg", "hommel", "bonferroni", "BH", "BY", "fdr" or "none".  If this is NULL, then no adjustment will be made.}

\item{seed}{The random seed that will be used.}
}
\value{
A matrix that has the same number of rows and columns as length(GOtypes).  This will contain p-values.
}
\description{
Draw network of enriched functional annotation pairs
}
\examples{
a=matrix(c(0.1, 0.003, 0.005, 0.004, 0.5, 0.7, 0.001, 0.002, 0.003), nrow=3)
colnames(a)=c('A', 'B', 'C')
rownames(a)=c('A', 'B', 'C')
draw_network(a)
}
